/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.command.defined;

import de.whiletrue.toolsmod.command.Arguments;
import de.whiletrue.toolsmod.command.CommandError;
import de.whiletrue.toolsmod.util.classes.TextUtil;

public abstract class Command {
    private final String name;
    private final String[] shortscuts;
    private boolean allowed = true;

    public Command(String name, String ... shortcuts) {
        this.name = name;
        this.shortscuts = shortcuts;
    }

    public abstract CommandError execute(Arguments var1);

    protected CommandError getSyntaxError() {
        return CommandError.of("global.error.command.syntax", Character.valueOf('#'), this.getName().toLowerCase(), this.getSyntax());
    }

    public String getName() {
        return this.name;
    }

    public String getSyntax() {
        return TextUtil.getInstance().getByKey("command." + this.getName().toLowerCase() + ".syntax");
    }

    public String[] getShortscuts() {
        return this.shortscuts;
    }

    public void setAllowed(boolean allowed) {
        this.allowed = allowed;
    }

    public boolean isAllowed() {
        return this.allowed;
    }
}

