/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.command.defined;

import de.whiletrue.toolsmod.command.ArgsReturn;
import de.whiletrue.toolsmod.command.Arguments;
import de.whiletrue.toolsmod.command.CommandError;
import de.whiletrue.toolsmod.command.defined.Command;
import de.whiletrue.toolsmod.module.defined.special.asedit.EditableArmorStand;
import de.whiletrue.toolsmod.module.defined.special.asedit.projects.AsEditProject;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class CommandAsSave
extends Command {
    public CommandAsSave() {
        super("AsSave", new String[0]);
    }

    @Override
    public CommandError execute(Arguments args) {
        ArgsReturn<BlockPos> pos = args.nextPosition();
        if (pos.hasArgumentError()) {
            return this.getSyntaxError();
        }
        if (pos.hasParseError()) {
            return CommandError.of("command.assave.error.pos", new Object[0]);
        }
        ArgsReturn<BlockPos> pos2 = args.nextPosition();
        if (pos.hasArgumentError()) {
            return CommandError.of("command.assave.error.pos2", new Object[0]);
        }
        if (pos.hasParseError()) {
            return CommandError.of("command.assave.error.pos", new Object[0]);
        }
        ArgsReturn<String> name = args.nextString();
        if (name.hasArgumentError()) {
            return CommandError.of("command.assave.error.name", new Object[0]);
        }
        return this.saveStands(pos.get(), pos2.get(), name.get());
    }

    private CommandError saveStands(BlockPos pos1, BlockPos pos2, String name) {
        if (!name.matches("\\w+")) {
            return CommandError.of("command.assave.error.name.invalid", name);
        }
        BlockPos[] region = this.getSizedRegion(pos1, pos2);
        int sizeX = region[1].func_177958_n() - region[0].func_177958_n();
        int sizeY = region[1].func_177956_o() - region[0].func_177956_o();
        int sizeZ = region[1].func_177952_p() - region[0].func_177952_p();
        if (sizeX > 40 || sizeY > 40 || sizeZ > 40) {
            return CommandError.of("command.assave.error.size", sizeX, sizeY, sizeZ);
        }
        double dist = region[0].func_177982_a(sizeX / 2, sizeY / 2, sizeZ / 2).func_177951_i((Vec3i)Minecraft.func_71410_x().field_71439_g.func_180425_c());
        if (dist > 20.0) {
            return CommandError.of("command.assave.error.dist", new Object[0]);
        }
        AsEditProject project = new AsEditProject(name, name);
        if (project.getFile().exists()) {
            return CommandError.of("command.assave.error.file", project.getName(-1));
        }
        EditableArmorStand[] stands = this.convertStandsToEditStands(region);
        if (stands.length <= 0) {
            return CommandError.of("command.assave.error.empty", new Object[0]);
        }
        project.saveProject(stands);
        TextUtil.getInstance().sendMessage("command.assave.success", stands.length, project.getName(-1));
        return CommandError.none();
    }

    private EditableArmorStand[] convertStandsToEditStands(BlockPos[] region) {
        return (EditableArmorStand[])StreamSupport.stream(Minecraft.func_71410_x().field_71441_e.func_217416_b().spliterator(), false).filter(i -> i instanceof ArmorStandEntity && !(i instanceof EditableArmorStand)).filter(p -> p.func_226277_ct_() >= (double)region[0].func_177958_n() || p.func_226277_ct_() <= (double)region[1].func_177958_n() || p.func_226278_cu_() >= (double)region[0].func_177956_o() || p.func_226278_cu_() <= (double)region[1].func_177956_o() || p.func_226281_cx_() >= (double)region[0].func_177952_p() || p.func_226281_cx_() <= (double)region[1].func_177952_p()).map(i -> new EditableArmorStand((ArmorStandEntity)i)).toArray(EditableArmorStand[]::new);
    }

    private BlockPos[] getSizedRegion(BlockPos pos1, BlockPos pos2) {
        return new BlockPos[]{new BlockPos(Math.min(pos1.func_177958_n(), pos2.func_177958_n()), Math.min(pos1.func_177956_o(), pos2.func_177956_o()), Math.min(pos1.func_177952_p(), pos2.func_177952_p())), new BlockPos(Math.max(pos1.func_177958_n(), pos2.func_177958_n()), Math.max(pos1.func_177956_o(), pos2.func_177956_o()), Math.max(pos1.func_177952_p(), pos2.func_177952_p()))};
    }
}

