/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.command.defined;

import de.whiletrue.toolsmod.command.ArgsReturn;
import de.whiletrue.toolsmod.command.Arguments;
import de.whiletrue.toolsmod.command.CommandError;
import de.whiletrue.toolsmod.command.defined.Command;
import de.whiletrue.toolsmod.mod.Toolsmod;
import de.whiletrue.toolsmod.module.defined.Module;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import java.util.List;

public class CommandHelp
extends Command {
    private final int CMDS_PER_PAGE = 5;

    public CommandHelp() {
        super("Help", "man");
    }

    @Override
    public CommandError execute(Arguments args) {
        ArgsReturn<Integer> page = args.nextInteger();
        if (page.hasArgumentError()) {
            this.showHelpPage(1);
            return CommandError.none();
        }
        if (!page.hasParseError()) {
            this.showHelpPage(page.get());
            return CommandError.none();
        }
        ArgsReturn<Module> mod = args.nextModule();
        if (mod.hasParseError()) {
            return CommandError.of("command.help.error.module", mod.getAsString());
        }
        this.showModuleInfo(mod.get());
        return CommandError.none();
    }

    public void showModuleInfo(Module mod) {
        TextUtil.getInstance().sendEmptyLine();
        TextUtil.getInstance().sendMessage("command.help.mod.wrapper", Character.valueOf('b'));
        TextUtil.getInstance().sendMessage("command.help.mod", mod.getName(), Toolsmod.getInstance().getModuleManager().getModules().size());
        TextUtil.getInstance().sendMessageRaw("\u00c2\u00a76" + mod.getDescription());
        TextUtil.getInstance().sendMessage("command.help.mod.wrapper", Character.valueOf('b'));
    }

    public void showHelpPage(int page) {
        List<Command> cmds = Toolsmod.getInstance().getCommandManager().getCommands();
        boolean work = cmds.size() % this.CMDS_PER_PAGE == 0;
        int pages = cmds.size() / this.CMDS_PER_PAGE + (work ? 0 : 1);
        if (--page >= pages || page < 0) {
            TextUtil.getInstance().sendError("command.help.error.page", page);
            return;
        }
        TextUtil.getInstance().sendEmptyLine();
        TextUtil.getInstance().sendMessage("command.help.page.wrapper", Character.valueOf('b'));
        TextUtil.getInstance().sendMessage("command.help.page", page + 1, pages, cmds.size());
        for (int i = page * this.CMDS_PER_PAGE; i < Math.min(cmds.size(), page * this.CMDS_PER_PAGE + this.CMDS_PER_PAGE); ++i) {
            String name = cmds.get(i).getName();
            String syntax = cmds.get(i).getSyntax();
            TextUtil.getInstance().sendMessageRaw(name + " " + syntax);
        }
        TextUtil.getInstance().sendMessage("command.help.page.wrapper", Character.valueOf('b'));
    }
}

