/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.command.defined;

import de.whiletrue.toolsmod.command.ArgsReturn;
import de.whiletrue.toolsmod.command.Arguments;
import de.whiletrue.toolsmod.command.CommandError;
import de.whiletrue.toolsmod.command.defined.Command;
import de.whiletrue.toolsmod.util.PlayerProfile;
import de.whiletrue.toolsmod.util.classes.MojangUtils;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import java.util.Optional;

public class CommandProfile
extends Command {
    private Thread searchThread;

    public CommandProfile() {
        super("Profile", "search", "find", "history");
    }

    @Override
    public CommandError execute(Arguments args) {
        ArgsReturn<String> optSearch = args.nextString();
        if (optSearch.hasArgumentError()) {
            return this.getSyntaxError();
        }
        this.searchFor(optSearch.get());
        return CommandError.none();
    }

    private void searchFor(String user) {
        if (this.searchThread != null) {
            this.searchThread.interrupt();
            this.searchThread = null;
            TextUtil.getInstance().sendMessage("command.profile.info", new Object[0]);
        }
        this.searchThread = new Thread(() -> {
            Optional<PlayerProfile> optionalProfile = MojangUtils.getInstance().getPlayerProfile(user);
            if (!optionalProfile.isPresent()) {
                TextUtil.getInstance().sendError("command.profile.error.search", user);
                this.searchThread = null;
                return;
            }
            PlayerProfile prof = optionalProfile.get();
            TextUtil.getInstance().sendMessage("command.profile.wrapper", new Object[0]);
            TextUtil.getInstance().sendMessage("command.profile.info.name", prof.getName());
            TextUtil.getInstance().sendMessage("command.profile.info.uuid", prof.getUuid());
            TextUtil.getInstance().sendEmptyLine();
            for (PlayerProfile.Name nms : prof.getPreviousNames()) {
                Optional<String> date = nms.formattedDate();
                if (date.isPresent()) {
                    TextUtil.getInstance().sendMessageRaw(String.format("%s | %s", nms.getName(), date.get()));
                    continue;
                }
                TextUtil.getInstance().sendMessageRaw(nms.getName());
            }
            this.searchThread = null;
        });
        this.searchThread.start();
    }
}

