/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.gui.quickaccess;

import de.whiletrue.toolsmod.gui.GuiGroup;
import de.whiletrue.toolsmod.gui.TmScreen;
import de.whiletrue.toolsmod.gui.widgets.preset.TmWidget;
import de.whiletrue.toolsmod.mod.ModSettings;
import de.whiletrue.toolsmod.util.classes.RenderUtil;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;

public class GuiQuickAccess
extends TmScreen {
    private static int currentX = 200;
    private static int currentY = 200;
    private final int x;
    private final int y;
    private String guiTitleKey;
    private String guiTitleShortKey;
    private String guiTitle;
    private String guiTitleShort;
    protected GuiGroup<GuiQuickAccess> group;
    protected RenderUtil renderer = RenderUtil.getInstance();
    protected Map<TmWidget, BiFunction<Integer, Integer, float[]>> sizeChangeListeners = new HashMap<TmWidget, BiFunction<Integer, Integer, float[]>>();

    protected GuiQuickAccess(String titleKey, String shortTitleKey, int x, int y) {
        this.x = x;
        this.y = y;
        this.guiTitleKey = titleKey;
        this.guiTitleShortKey = shortTitleKey;
    }

    @Override
    public void init(Minecraft p_init_1_, int p_init_2_, int p_init_3_) {
        this.sizeChangeListeners.clear();
        super.init(p_init_1_, p_init_2_, p_init_3_);
        this.handleSizeChange(currentX, currentY);
    }

    @Override
    public void onGroupGuiUpdate(GuiGroup<? extends TmScreen> group) {
        this.guiTitle = this.guiTitleKey.charAt(0) == '#' ? this.guiTitleKey.substring(1) : TextUtil.getInstance().getByKey(this.guiTitleKey);
        this.guiTitleShort = this.guiTitleShortKey.charAt(0) == '#' ? this.guiTitleShortKey.substring(1) : TextUtil.getInstance().getByKey(this.guiTitleShortKey);
        this.group = group;
    }

    @Override
    public void render(int mouseX, int mouseY, float p_render_3_) {
        this.renderQuickAccessGui();
        super.render(mouseX, mouseY, p_render_3_);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.mouseClickedQuickAccessQui(mouseX, mouseY)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void renderQuickAccessGui() {
        this.renderer.renderRect(this.width / 2 - currentX / 2, this.height / 2 - currentY / 2, currentX, currentY, -14801617);
        this.renderer.renderRect(this.width / 2 - currentX / 2, this.height / 2 - currentY / 2, currentX, 20, -16777216);
        this.renderer.renderRect(this.width / 2 - currentX / 2, this.height / 2 - currentY / 2, 50, currentY, -16777216);
        this.drawCenteredString(this.font, this.guiTitle, this.width / 2 + 25, this.height / 2 - currentY / 2 + 6, -1);
        for (int i = 0; i < this.group.getSize(); ++i) {
            this.renderer.renderRect(this.width / 2 - currentX / 2, this.height / 2 - currentY / 2 + 20 + i * 20, 50, 20, i == this.group.getIndex() ? -1156572 : -16777216);
            this.drawCenteredString(this.font, this.group.getGui(i).getGuiTitleShort(), this.width / 2 - currentX / 2 + 25, this.height / 2 - currentY / 2 + 26 + i * 20, -1);
        }
        this.updateSize();
    }

    protected boolean mouseClickedQuickAccessQui(double mX, double mY) {
        for (int i = 0; i < this.group.getSize(); ++i) {
            int x = this.width / 2 - currentX / 2;
            int height = 20;
            int y = this.height / 2 - currentY / 2 + 20 + i * height;
            int width = 50;
            if (!(mX > (double)x) || !(mX < (double)(x + width)) || !(mY > (double)y) || !(mY < (double)(y + height))) continue;
            this.group.update(i);
            return true;
        }
        return false;
    }

    private void updateSize() {
        if (currentX != this.x || currentY != this.y) {
            for (int i = 0; i < (Integer)ModSettings.quickAccessGuiSpeed.value; ++i) {
                if (currentY < this.y) {
                    ++currentY;
                } else if (currentY > this.y) {
                    --currentY;
                }
                if (currentX < this.x) {
                    ++currentX;
                } else if (currentX > this.x) {
                    --currentX;
                }
                this.handleSizeChange(currentX, currentY);
            }
        }
    }

    public void setGroup(GuiGroup<GuiQuickAccess> group) {
        this.group = group;
    }

    public String getGuiTitleShort() {
        return this.guiTitleShort;
    }

    protected void handleSizeChange(int sizeX, int sizeY) {
        this.sizeChangeListeners.forEach((k, v) -> k.move((float[])v.apply(sizeX, sizeY)));
    }

    protected void addWidgetWithListener(TmWidget widget, BiFunction<Integer, Integer, float[]> handler) {
        this.sizeChangeListeners.put(widget, handler);
        this.addWidget(widget);
    }
}

