/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.gui.widgets;

import de.whiletrue.toolsmod.gui.widgets.preset.TmSizeWidget;
import de.whiletrue.toolsmod.gui.widgets.preset.TmWidget;
import java.util.Optional;
import java.util.function.Function;

public class TmCheckboxColor
extends TmSizeWidget {
    private boolean checked;
    private int outlineColor;
    private int fillColor;
    private int outlineStrength;
    private Function<Boolean, Boolean> onCheck;

    public TmCheckboxColor(int x, int y, int width, int height, boolean checked, Function<Boolean, Boolean> onCheck) {
        this(x, y, width, height, checked, -16777216, -30185, 1, onCheck);
    }

    public TmCheckboxColor(int x, int y, int width, int height, boolean checked, int outlineColor, int fillColor, int outlineStrength, Function<Boolean, Boolean> onCheck) {
        super(x, y, width, height);
        this.checked = checked;
        this.onCheck = onCheck;
        this.outlineColor = outlineColor;
        this.fillColor = fillColor;
        this.outlineStrength = outlineStrength;
    }

    @Override
    public Optional<TmWidget> onMouseClicked(double mX, double mY, int ticks) {
        if (this.hovered) {
            this.checked = this.onCheck.apply(!this.checked);
        }
        return Optional.empty();
    }

    @Override
    public void onRender(int mX, int mY, float ticks, TmWidget focused) {
        super.onRender(mX, mY, ticks, focused);
        this.renderer.renderOutline(this.x, this.y, this.width, this.height, this.outlineStrength, this.outlineColor);
        if (this.checked) {
            this.renderer.renderRect(this.x + this.outlineStrength + 1, this.y + this.outlineStrength + 1, this.width - this.outlineStrength * 2 - 2, this.height - this.outlineStrength * 2 - 2, this.fillColor);
        }
    }

    public boolean isChecked() {
        return this.checked;
    }

    public TmCheckboxColor setChecked(boolean checked) {
        this.checked = checked;
        return this;
    }
}

