/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.gui.widgets;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.whiletrue.toolsmod.gui.widgets.preset.TmSizeWidget;
import de.whiletrue.toolsmod.gui.widgets.preset.TmWidget;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import java.util.Optional;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class TmItemButton
extends TmSizeWidget {
    private IUpdateable onClick;
    private ItemStack stack;
    private IBakedModel model;
    private boolean enabled = true;
    private String tooltipp;

    public TmItemButton(int x, int y, ItemStack item, IUpdateable onClick) {
        super(x, y, 20, 20);
        this.setStack(item);
        this.onClick = onClick;
    }

    public TmItemButton(int x, int y, Item item, IUpdateable onClick) {
        this(x, y, new ItemStack((IItemProvider)item), onClick);
    }

    public TmItemButton setTooltipp(String tooltip) {
        this.tooltipp = tooltip;
        return this;
    }

    public TmItemButton setTooltippByKey(String key, Object ... args) {
        this.tooltipp = TextUtil.getInstance().getByKey(key, args);
        return this;
    }

    public TmItemButton setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public TmItemButton setStack(ItemStack stack) {
        this.stack = stack;
        this.model = this.mc.func_175599_af().func_184393_a(this.stack, null, (LivingEntity)this.mc.field_71439_g);
        return this;
    }

    @Override
    public Optional<TmWidget> onMouseClicked(double mX, double mY, int ticks) {
        if (this.hovered) {
            this.onClick.execute(this);
        }
        return Optional.empty();
    }

    @Override
    public void onRender(int mX, int mY, float ticks, TmWidget focused) {
        super.onRender(mX, mY, ticks, focused);
        this.renderButton();
        this.renderer.renderItem(this.stack, this.model, this.x + 2, this.y + 2);
    }

    @Override
    public boolean onPostRender(int mX, int mY) {
        if (this.hovered && this.enabled && this.tooltipp != null) {
            this.mc.func_175599_af().field_77023_b = 0.0f;
            this.mc.field_71462_r.renderTooltip(this.tooltipp, mX, mY);
            return true;
        }
        return false;
    }

    private void renderButton() {
        this.mc.func_110434_K().func_110577_a(Widget.WIDGETS_LOCATION);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.enabled ? (this.hovered ? 2 : 1) : 0;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int blitOffset = -90;
        AbstractGui.blit((int)this.x, (int)this.y, (int)blitOffset, (float)0.0f, (float)(46 + i * 20), (int)(this.width / 2), (int)this.height, (int)256, (int)256);
        AbstractGui.blit((int)(this.x + this.width / 2), (int)this.y, (int)blitOffset, (float)(200 - this.width / 2), (float)(46 + i * 20), (int)(this.width / 2), (int)this.height, (int)256, (int)256);
    }

    @FunctionalInterface
    public static interface IUpdateable {
        public void execute(TmItemButton var1);
    }
}

