/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.gui.widgets;

import de.whiletrue.toolsmod.gui.widgets.TmButton;
import de.whiletrue.toolsmod.gui.widgets.preset.TmWidget;
import de.whiletrue.toolsmod.util.Keybind;
import java.util.Optional;
import java.util.function.Consumer;

public class TmKeybindButton
extends TmButton {
    private Consumer<Keybind> onSelect;
    private Keybind bind;

    public TmKeybindButton(int x, int y, int width, int height, Keybind keyBind, Consumer<Keybind> onSelect) {
        super(x, y, width, height, null, null);
        this.onSelect = onSelect;
        this.bind = keyBind;
        this.updateDisplay();
    }

    @Override
    public Optional<TmWidget> onMouseClicked(double mX, double mY, int ticks) {
        if (this.enabled && this.hovered) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @Override
    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        this.bind.updateFromEvent(keyCode);
        this.updateDisplay();
        this.onSelect.accept(this.bind);
        return true;
    }

    @Override
    public boolean onKeyReleased(int keyCode, int scanCode, int modifiers) {
        this.unFocuse();
        return true;
    }

    @Override
    protected String getRenderText(boolean focused) {
        return focused ? "> \u00a7e" + this.display + "\u00a7r <" : super.getRenderText(focused);
    }

    public void updateDisplay() {
        this.display = this.bind.getName();
    }
}

