/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.whiletrue.toolsmod.gui.widgets.preset.TmWidget;
import de.whiletrue.toolsmod.util.TextAlign;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class TmTextWidget
extends TmWidget {
    protected int x;
    protected int y;
    protected int color;
    protected double scale = 1.0;
    private TextAlign alignX = TextAlign.MIDDLE;
    private TextAlign alignY = TextAlign.BEFORE;
    private String[] renderText;
    private boolean specialRender = false;

    public TmTextWidget(int x, int y, String msg, int color) {
        this.x = x;
        this.y = y;
        this.color = color;
        this.setText(msg);
    }

    public TmTextWidget setTextByKey(String key, Object ... args) {
        return this.setText(TextUtil.getInstance().getByKey(key, args).split("\n"));
    }

    public TmTextWidget setText(String ... msg) {
        this.renderText = msg;
        return this;
    }

    public TmTextWidget setAlignX(TextAlign align) {
        this.alignX = align;
        return this;
    }

    public TmTextWidget setAlignY(TextAlign align) {
        this.alignY = align;
        return this;
    }

    public TmTextWidget setScale(double scale) {
        this.scale = scale;
        return this;
    }

    public TmTextWidget setSpecialRender(boolean special) {
        this.specialRender = special;
        return this;
    }

    @Override
    public boolean isMouseOver(double mX, double mY) {
        return false;
    }

    @Override
    public void move(float ... size) {
        this.x = (int)size[0];
        this.y = (int)size[1];
    }

    @Override
    public void onRender(int mX, int mY, float ticks, TmWidget focused) {
        if (this.renderText == null) {
            return;
        }
        FontRenderer font = this.mc.field_71466_p;
        GL11.glPushMatrix();
        GL11.glScaled((double)this.scale, (double)this.scale, (double)this.scale);
        font.getClass();
        int textHeight = 9 * this.renderText.length;
        for (int i = 0; i < this.renderText.length; ++i) {
            int textWidth = font.func_78256_a(this.renderText[i]);
            int x = (int)((double)this.x / this.scale - (double)(this.alignX.equals((Object)TextAlign.BEFORE) ? 0 : (this.alignX.equals((Object)TextAlign.MIDDLE) ? textWidth / 2 : textWidth)));
            double d = (double)this.y / this.scale;
            font.getClass();
            int y = (int)(d + (double)(i * 9) - (double)(this.alignY.equals((Object)TextAlign.BEFORE) ? 0 : (this.alignY.equals((Object)TextAlign.MIDDLE) ? textHeight / 2 : textHeight)));
            if (this.specialRender) {
                this.specialRender(font, x, y, i);
                continue;
            }
            this.mc.field_71466_p.func_175063_a(this.renderText[i], (float)x, (float)y, this.color);
        }
        GL11.glPopMatrix();
    }

    private void specialRender(FontRenderer font, int x, int y, int i) {
        this.mc.func_175599_af().field_77023_b = 300.0f;
        MatrixStack matrixstack = new MatrixStack();
        IRenderTypeBuffer.Impl irendertypebuffer$impl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        matrixstack.func_227861_a_(0.0, 0.0, (double)this.mc.func_175599_af().field_77023_b);
        Matrix4f matrix4f = matrixstack.func_227866_c_().func_227870_a_();
        font.func_228079_a_(this.renderText[i], (float)x, (float)y, this.color, true, matrix4f, (IRenderTypeBuffer)irendertypebuffer$impl, false, 0, 0xF000F0);
        irendertypebuffer$impl.func_228461_a_();
        this.mc.func_175599_af().field_77023_b = 0.0f;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }
}

