/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.gui.widgets.rounding.listmultirow;

import de.whiletrue.toolsmod.gui.widgets.preset.TmSizeWidget;
import de.whiletrue.toolsmod.gui.widgets.preset.TmWidget;
import de.whiletrue.toolsmod.gui.widgets.rounding.EnumListSlider;
import de.whiletrue.toolsmod.gui.widgets.rounding.listmultirow.MultirowListItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.math.MathHelper;

public class MultirowListView<ItemView extends MultirowListItem<?>>
extends TmSizeWidget {
    private int scrolled;
    private int spaceX;
    private int spaceY;
    private int itemsPerRow;
    private int itemHeight;
    private float scrollStrength = 1.0f;
    private EnumListSlider slider = EnumListSlider.RIGHT;
    private int background = -1;
    private Function<ItemView, Boolean> validator = null;
    private int sliderWidth = 6;
    private int itemWidth;
    private List<ItemView> views = new ArrayList<ItemView>();
    private int dragOffset;
    private int sliderHeight;
    private int listHeight;
    private int[] viewIndexes;

    public MultirowListView(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setListFormatting(0, 5, 1, 30);
    }

    public MultirowListView<ItemView> setListFormatting(int spaceX, int spaceY, int itemsPerRow, int itemHeight) {
        this.spaceX = spaceX;
        this.spaceY = spaceY;
        this.itemsPerRow = itemsPerRow;
        this.itemHeight = itemHeight;
        this.calculateViewIndexes();
        this.calculateItemWidth();
        this.calculateListHeight();
        this.updateItems();
        this.updateScroll(this.scrolled);
        return this;
    }

    public MultirowListView<ItemView> setScrollStrength(float scrollStrength) {
        this.scrollStrength = scrollStrength;
        return this;
    }

    public MultirowListView<ItemView> setSlider(EnumListSlider slider) {
        this.slider = slider;
        return this;
    }

    public MultirowListView<ItemView> setBackground(int background) {
        this.background = background;
        return this;
    }

    public MultirowListView<ItemView> setItems(ItemView ... items) {
        this.views.clear();
        this.views.addAll(Arrays.asList(items));
        this.updateListIndexes();
        this.calculateListHeight();
        this.updateScroll(this.scrolled);
        this.updateItems();
        return this;
    }

    public MultirowListView<ItemView> setValidator(Function<ItemView, Boolean> validator) {
        this.validator = validator;
        return this;
    }

    public void addItem(ItemView item) {
        this.views.add(item);
        this.updateListIndexes();
        this.calculateListHeight();
        this.updateScroll(this.scrolled);
        this.updateItems();
    }

    public void remove(ItemView item) {
        this.views.remove(item);
        this.updateListIndexes();
        this.calculateListHeight();
        this.updateScroll(this.scrolled);
        this.updateItems();
    }

    public void updateListIndexes() {
        for (int i = 0; i < this.views.size(); ++i) {
            ((MultirowListItem)this.views.get(i)).setIndex(i);
            ((MultirowListItem)this.views.get(i)).handleListSizeChange(this.views.size());
        }
    }

    private void calculateViewIndexes() {
        this.viewIndexes = new int[this.height / (this.itemHeight + this.spaceY) * this.itemsPerRow + this.itemsPerRow * 2];
    }

    private void calculateItemWidth() {
        this.itemWidth = (this.width - this.spaceX * (this.itemsPerRow - 1)) / this.itemsPerRow;
    }

    public void updateValidation() {
        this.calculateListHeight();
        this.updateScroll(this.scrolled);
        this.updateItems();
    }

    public void updateScroll(int newScroll) {
        this.scrolled = this.listHeight > this.height ? MathHelper.func_76125_a((int)newScroll, (int)0, (int)(this.listHeight - this.height)) : 0;
        this.sliderHeight = Math.max(20, (int)((float)this.height * ((float)this.height / (float)this.listHeight)));
    }

    private void calculateListHeight() {
        int working = 0;
        for (int i = 0; i < this.views.size(); ++i) {
            if (this.validator != null && !this.validator.apply(this.views.get(i)).booleanValue()) continue;
            ++working;
        }
        this.listHeight = (this.itemHeight + this.spaceY) * (int)Math.ceil((float)working / (float)this.itemsPerRow) - this.spaceY;
    }

    public void updateItems() {
        int cur = 0;
        int working = 0;
        block0: for (int i = 0; i < this.viewIndexes.length; ++i) {
            this.viewIndexes[i] = -1;
            while (cur < this.views.size()) {
                MultirowListItem iv = (MultirowListItem)this.views.get(cur);
                if (this.validator == null || this.validator.apply(iv).booleanValue()) {
                    int y = this.y + (this.itemHeight + this.spaceY) * (working / this.itemsPerRow) - this.scrolled;
                    if (y + this.itemHeight > this.y) {
                        this.viewIndexes[i] = cur++;
                        int x = this.x + (this.itemWidth + this.spaceX) * (working % this.itemsPerRow);
                        iv.handlChangePosition(x, y, this.itemWidth, this.itemHeight);
                        ++working;
                        continue block0;
                    }
                    ++working;
                }
                ++cur;
            }
        }
    }

    private int getSliderY() {
        return (int)((float)this.y + (float)(this.height - this.sliderHeight) * ((float)this.scrolled / (float)(this.listHeight - this.height)));
    }

    @Override
    public void onRender(int mX, int mY, float ticks, TmWidget focused) {
        super.onRender(mX, mY, ticks, focused);
        if (!this.hovered) {
            mX = this.x - 5;
            mY = this.y - 5;
        }
        if (this.background != -1) {
            AbstractGui.fill((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)this.background);
        }
        this.renderer.startScissor(this.x, this.y, this.width, this.height);
        for (int i : this.viewIndexes) {
            if (i == -1) continue;
            ((MultirowListItem)this.views.get(i)).render(mX, mY, ticks, focused);
        }
        this.renderer.stopScissor();
        if (this.listHeight > this.height && !this.slider.equals((Object)EnumListSlider.NONE)) {
            int sX = this.x + (this.slider.equals((Object)EnumListSlider.LEFT) ? -this.sliderWidth : this.width);
            int sY = this.getSliderY();
            this.renderer.renderRect(sX, this.y, this.sliderWidth, this.height, -16777216);
            this.renderer.renderRect(sX, sY, this.sliderWidth, this.sliderHeight, -8355712);
            this.renderer.renderRect(sX, sY, this.sliderWidth - 1, this.sliderHeight - 1, -4144960);
        }
    }

    @Override
    public boolean onPostRender(int mX, int mY) {
        if (!this.hovered) {
            return false;
        }
        for (int i : this.viewIndexes) {
            if (i == -1 || !((MultirowListItem)this.views.get(i)).onPostRender(mX, mY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void move(float ... size) {
        super.move(size);
        this.calculateViewIndexes();
        this.calculateItemWidth();
        this.updateScroll(this.scrolled);
        this.updateItems();
    }

    @Override
    public Optional<TmWidget> onMouseClicked(double mX, double mY, int ticks) {
        if (this.listHeight > this.height && !this.slider.equals((Object)EnumListSlider.NONE)) {
            int sliderY = this.getSliderY();
            int sliderX = this.x + (this.slider.equals((Object)EnumListSlider.LEFT) ? -this.sliderWidth : this.width);
            if (mX >= (double)sliderX && mX <= (double)(sliderX + this.sliderWidth) && mY >= (double)sliderY && mY <= (double)(sliderY + this.sliderHeight)) {
                this.dragOffset = (int)(mY - (double)sliderY);
                return Optional.of(this);
            }
        }
        if (!this.hovered) {
            return Optional.empty();
        }
        for (int i : this.viewIndexes) {
            TmWidget wid;
            if (i == -1 || (wid = ((MultirowListItem)this.views.get(i)).onMouseClicked(mX, mY, ticks)) == null) continue;
            return Optional.of(wid);
        }
        return Optional.empty();
    }

    @Override
    public boolean onMouseDragged(double mX, double mY, int arg2, double arg3, double arg4) {
        double perc = MathHelper.func_151237_a((double)((mY - (double)this.dragOffset - (double)this.y) / (double)(this.height - this.sliderHeight)), (double)0.0, (double)1.0);
        this.updateScroll((int)((double)(this.listHeight - this.height) * perc));
        this.updateItems();
        return true;
    }

    @Override
    public boolean onMouseScrolled(double mX, double mY, double strength) {
        this.updateScroll((int)((double)this.scrolled - strength * (double)this.scrollStrength));
        this.updateItems();
        return true;
    }

    @Override
    public void onTick() {
        this.views.forEach(i -> i.onTick());
    }

    public List<ItemView> getViews() {
        return this.views;
    }

    public int getScrolled() {
        return this.scrolled;
    }

    public void clearWithoutCheck() {
        this.views.clear();
    }
}

