/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.gui.widgets.rounding.listscaleable;

import de.whiletrue.toolsmod.gui.widgets.preset.TmWidget;
import de.whiletrue.toolsmod.util.classes.RenderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;

public abstract class ScaleableListItem<T> {
    protected final T item;
    protected final List<TmWidget> widgets = new ArrayList<TmWidget>();
    protected static final Minecraft GAME = Minecraft.func_71410_x();
    protected static final RenderUtil RENDERER = RenderUtil.getInstance();
    protected int index;
    protected int x;
    protected int y;
    protected int width;
    private int height;
    private Runnable onHeightChange;

    public ScaleableListItem(T item) {
        this.item = item;
    }

    public void handlePostInit(Runnable onHeightChange, int x, int w) {
        this.onHeightChange = onHeightChange;
        this.setHeight(this.handleChangePosition(x, w));
    }

    public int handleChangePosition(int x, int w) {
        this.x = x;
        this.width = w;
        return -1;
    }

    public void handleChangePositionScrolled(int y) {
        this.y = y;
    }

    public void handleListSizeChange(int size) {
    }

    public void render(int mX, int mY, float ticks, TmWidget focused) {
        this.widgets.forEach(i -> i.onRender(mX, mY, ticks, focused));
    }

    public boolean onPostRender(int mX, int mY) {
        for (int i = 0; i < this.widgets.size(); ++i) {
            if (!this.widgets.get(i).onPostRender(mX, mY)) continue;
            return true;
        }
        return false;
    }

    public TmWidget onMouseClicked(double mX, double mY, int modifiers) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Optional<TmWidget> widget = this.widgets.get(i).onMouseClicked(mX, mY, modifiers);
            if (!widget.isPresent()) continue;
            return widget.get();
        }
        return null;
    }

    public void onTick() {
        this.widgets.forEach(i -> i.onTick());
    }

    protected void updateHeight(int newHeight) {
        if (this.onHeightChange != null) {
            this.height = newHeight;
            this.onHeightChange.run();
        }
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public T getItem() {
        return this.item;
    }

    public int getHeight() {
        return this.height;
    }
}

