/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.mod;

import com.google.gson.JsonObject;
import de.whiletrue.toolsmod.mod.ModSettings;
import de.whiletrue.toolsmod.settings.Setting;
import de.whiletrue.toolsmod.util.classes.FileUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SettingsManager {
    private final File settingsFile;
    private List<Setting<?>> settingsList;

    public SettingsManager(String settingsFile) {
        this.settingsFile = new File("toolsmod/" + settingsFile);
        this.settingsList = Arrays.stream(ModSettings.class.getDeclaredFields()).filter(i -> Setting.class.isAssignableFrom(i.getType())).map(i -> {
            try {
                i.setAccessible(true);
                return (Setting)i.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                return null;
            }
        }).collect(Collectors.toList());
        this.load();
    }

    public void save() {
        JsonObject save = new JsonObject();
        for (Setting<?> set : this.settingsList) {
            save.addProperty(set.getName(), set.handleSave());
        }
        FileUtil.getInstance().printToFile(this.settingsFile.getAbsolutePath(), save);
    }

    public void load() {
        try {
            JsonObject saved = FileUtil.getInstance().loadFileAsJson(this.settingsFile.getAbsolutePath()).get().getAsJsonObject();
            for (Setting<?> set : this.settingsList) {
                if (!saved.has(set.getName())) continue;
                set.handleParse(saved.get(set.getName()).getAsString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.save();
        }
    }

    public List<Setting<?>> getSettings() {
        return this.settingsList;
    }
}

