/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.module.defined.special;

import de.whiletrue.toolsmod.gui.GuiGroup;
import de.whiletrue.toolsmod.gui.TmScreen;
import de.whiletrue.toolsmod.gui.quickaccess.GuiQuickAccess;
import de.whiletrue.toolsmod.mod.Toolsmod;
import de.whiletrue.toolsmod.module.ModuleCategory;
import de.whiletrue.toolsmod.module.defined.Module;
import de.whiletrue.toolsmod.module.defined.special.bannerwriter.EnumBannertypes;
import de.whiletrue.toolsmod.module.defined.special.bannerwriter.EnumDye;
import de.whiletrue.toolsmod.module.defined.special.bannerwriter.gui.GuiQaBannerWriter;
import de.whiletrue.toolsmod.util.classes.ItemUtil;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.BannerItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.world.BlockEvent;

public class ModuleBannerWriter
extends Module {
    private static GuiGroup<GuiQuickAccess> ENABLE_GUI = GuiGroup.of((TmScreen[])new GuiQuickAccess[]{new GuiQaBannerWriter()});
    private List<ItemStack> remaningBanners = new ArrayList<ItemStack>();
    private boolean enabled;
    private String currentText;
    private String letterName;
    private String backgroundName;

    public ModuleBannerWriter() {
        super("BannerWriter", ModuleCategory.TOOLS, false);
    }

    @Override
    public void onEnable() {
        if (!this.enabled) {
            this.disable();
            ENABLE_GUI.open();
            return;
        }
        this.enabled = false;
        this.giveNextBanner();
    }

    @Override
    public void onPlace(BlockEvent.EntityPlaceEvent event) {
        if (!Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
            TextUtil.getInstance().sendError("modules.bannerwriter.error.gm", new Object[0]);
            this.disable();
            return;
        }
        if (!(this.mc.field_71439_g.func_184614_ca().func_77973_b() instanceof BannerItem)) {
            return;
        }
        this.giveNextBanner();
    }

    @Override
    public void onDisable() {
        this.enabled = false;
    }

    @Override
    public String[] onInformationEvent(char main, char sec) {
        return new String[]{String.format("\u00a7%cText: \u00a7%c%s", Character.valueOf(main), Character.valueOf(sec), this.currentText), String.format("\u00a7%cColors: \u00a7%c%s | %s", Character.valueOf(main), Character.valueOf(sec), this.letterName, this.backgroundName), String.format("\u00a7%cRemaining: \u00a7%c%s", Character.valueOf(main), Character.valueOf(sec), this.remaningBanners.size() + 1)};
    }

    private void giveNextBanner() {
        if (this.remaningBanners.isEmpty()) {
            this.disable();
            ItemUtil.getInstance().setItem(ItemStack.field_190927_a);
            return;
        }
        ItemUtil.getInstance().setItem(this.remaningBanners.get(0));
        this.remaningBanners.remove(0);
        Toolsmod.getInstance().getModuleManager().updateInfoDisplay();
    }

    public void startWriting(String text, EnumDye letter, EnumDye background) {
        this.disable();
        if (!Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
            TextUtil.getInstance().sendError("modules.bannerwriter.error.gm", new Object[0]);
            return;
        }
        this.remaningBanners.clear();
        this.currentText = text;
        this.letterName = letter.getName();
        this.backgroundName = background.getName();
        for (char c : text.toLowerCase().toCharArray()) {
            CompoundNBT nbt = EnumBannertypes.getByChar(c).getTag(letter, background, true);
            ItemStack head = new ItemStack((IItemProvider)background.getBanner());
            head.func_77982_d(nbt);
            head.func_200302_a((ITextComponent)new StringTextComponent(String.format("\u00a78[\u00a7%c" + this.getName() + "\u00a78]: \u00a7%c%s", Character.valueOf('b'), Character.valueOf('6'), text)));
            this.remaningBanners.add(head);
        }
        this.mc.func_147108_a(null);
        this.enabled = true;
        this.enable();
    }
}

