/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.module.defined.special.asedit;

import de.whiletrue.toolsmod.module.defined.special.asedit.EnumMoveType;
import de.whiletrue.toolsmod.util.Timer;
import de.whiletrue.toolsmod.util.classes.ItemUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EditableArmorStand
extends ArmorStandEntity {
    private static int COUNTER_ID = 0xFFFFFF;
    private Timer selectTimer;
    private String referenceName;
    private boolean selected = false;

    public EditableArmorStand(ArmorStandEntity stand) {
        super(EntityType.field_200789_c, (World)Minecraft.func_71410_x().field_71441_e);
        this.func_180432_n((Entity)stand);
        this.referenceName = "";
    }

    public EditableArmorStand(double x, double y, double z) {
        super(EntityType.field_200789_c, (World)Minecraft.func_71410_x().field_71441_e);
        this.func_145769_d(COUNTER_ID++);
        this.func_70107_b(x, y, z);
        this.referenceName = "New armorstand";
    }

    public boolean func_225510_bt_() {
        if (this.selectTimer != null) {
            if (this.selectTimer.hasReached(1000L)) {
                this.selectTimer = null;
            } else {
                return true;
            }
        }
        return super.func_225510_bt_();
    }

    public boolean isGlowingNatrual() {
        return super.func_225510_bt_();
    }

    public void doReset() {
        Vec3d position = this.func_213303_ch();
        this.func_70020_e(new CompoundNBT());
        this.func_200203_b(null);
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            this.func_184201_a(slot, ItemStack.field_190927_a);
        }
        this.func_70107_b(position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
    }

    public EditableArmorStand doClone() {
        CompoundNBT clonedNbt = ItemUtil.getInstance().getTagFromArmorstand(this);
        EditableArmorStand clone = new EditableArmorStand(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        if (clonedNbt != null) {
            clone.func_70020_e(clonedNbt);
        }
        clone.referenceName = this.referenceName;
        return clone;
    }

    public boolean getAttr(int attrId) {
        return ((Byte)this.field_70180_af.func_187225_a(field_184801_a) & attrId) != 0;
    }

    public void setAttr(int attrId, boolean state) {
        byte dataParameter = (Byte)this.field_70180_af.func_187225_a(field_184801_a);
        this.field_70180_af.func_187227_b(field_184801_a, (Object)((byte)(state ? dataParameter | attrId : dataParameter & ~attrId)));
    }

    public void swapAttr(int attrId) {
        this.setAttr(attrId, this.getAttr(attrId));
    }

    public void updateBodyRotation(EnumMoveType type, int dimension, float value) {
        Rotations old = type.getRotation(this);
        float x = old.func_179415_b() + (dimension == 0 ? value : 0.0f);
        float y = old.func_179416_c() + (dimension == 1 ? value : 0.0f);
        float z = old.func_179413_d() + (dimension == 2 ? value : 0.0f);
        type.setRotation(this, new Rotations(x % 360.0f, y % 360.0f, z % 360.0f));
    }

    public void setBodyRotation(EnumMoveType type, int dimension, float value) {
        Rotations old = type.getRotation(this);
        float x = dimension == 0 ? value : old.func_179415_b();
        float y = dimension == 1 ? value : old.func_179416_c();
        float z = dimension == 2 ? value : old.func_179413_d();
        type.setRotation(this, new Rotations(x % 360.0f, y % 360.0f, z % 360.0f));
    }

    public void updateGeneralRotation(float value) {
        this.field_70177_z = (this.field_70177_z + value) % 360.0f;
    }

    public void moveInRelationToStand(EditableArmorStand stand, float angle) {
        this.updateGeneralRotation((float)((double)angle / (Math.PI * 2) * 360.0));
        if (this.equals((Object)stand)) {
            return;
        }
        double x = this.func_226277_ct_() - stand.func_226277_ct_();
        double y = this.func_226281_cx_() - stand.func_226281_cx_();
        double newx = x * Math.cos(angle) - y * Math.sin(angle);
        double newy = x * Math.sin(angle) + y * Math.cos(angle);
        this.func_70107_b(newx + stand.func_226277_ct_(), this.func_226278_cu_(), newy + stand.func_226281_cx_());
    }

    public void updatePosition(int dimension, float value) {
        double x = this.func_226277_ct_() + (double)(dimension == 0 ? value : 0.0f);
        double y = this.func_226278_cu_() + (double)(dimension == 1 ? value : 0.0f);
        double z = this.func_226281_cx_() + (double)(dimension == 2 ? value : 0.0f);
        this.func_70107_b(x, y, z);
    }

    public void setPosition(int dimension, float value) {
        double x = dimension == 0 ? (double)value : this.func_226277_ct_();
        double y = dimension == 1 ? (double)value : this.func_226278_cu_();
        double z = dimension == 2 ? (double)value : this.func_226281_cx_();
        this.func_70107_b(x, y, z);
    }

    public void setDisabledSlots(boolean disabled) {
        this.field_175442_bg = disabled ? 0x1FFFFF : 0;
    }

    public boolean areSlotsDisabled() {
        return this.field_175442_bg != 0;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        if (this.selected == selected) {
            return;
        }
        this.selected = selected;
        this.selectTimer = selected ? new Timer() : null;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public void setReferenceName(String referenceName) {
        this.referenceName = referenceName;
    }
}

