/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.module.defined.special.asedit.gui.defined;

import de.whiletrue.toolsmod.gui.TmScreen;
import de.whiletrue.toolsmod.gui.widgets.TmBackgroundWidget;
import de.whiletrue.toolsmod.gui.widgets.TmTextWidget;
import de.whiletrue.toolsmod.gui.widgets.TmTextfield;
import de.whiletrue.toolsmod.gui.widgets.TmUpdateButton;
import de.whiletrue.toolsmod.gui.widgets.rounding.listmultirow.MultirowListView;
import de.whiletrue.toolsmod.mod.Toolsmod;
import de.whiletrue.toolsmod.module.defined.special.ModuleAsEdit;
import de.whiletrue.toolsmod.module.defined.special.asedit.gui.list.ProjectItem;
import de.whiletrue.toolsmod.module.defined.special.asedit.projects.AsEditProject;
import de.whiletrue.toolsmod.module.defined.special.asedit.projects.EnumProjectVersion;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.util.Util;

public class GuiAsEditProjectsLoad
extends TmScreen {
    private final String dir = "toolsmod/assaves/";
    private ModuleAsEdit module;
    private TmTextWidget info;
    private long millis = -1L;
    private TmBackgroundWidget infoBg;
    private MultirowListView<ProjectItem> list;

    protected void init() {
        this.module = Toolsmod.getInstance().getModuleManager().getModuleByClass(ModuleAsEdit.class).get();
        int lH = 35;
        int rW = (int)Math.min(300.0f, (float)this.width * 0.7f);
        int lX = this.width - rW < 200 ? 10 : this.width / 2 - rW / 2;
        this.list = new MultirowListView(lX, lH + 23, rW, this.height - lH - 23).setListFormatting(0, 5, 1, 40).setScrollStrength(10.0f).setBackground(0);
        this.addWidget(this.list);
        this.addWidget(new TmTextWidget(this.width / 2, 4, TextUtil.getInstance().getByKey("modules.asedit.gui.projectsselect.title"), -16724225).setScale(2.0));
        TmTextfield search = new TmTextfield(lX, 35, rW, 15, "", i -> this.list.updateValidation());
        this.addWidget(search);
        this.list.setValidator(i -> i.isValid(search.getText()));
        this.updateList();
        int btnW = Math.min(80, this.width - lX - rW - 10);
        this.addWidget(new TmUpdateButton(lX + rW + (this.width - lX - rW) / 2 - btnW / 2, lH - 2, btnW, 20, btn -> {
            if (btn != null) {
                this.module.guis.update();
            }
            return TextUtil.getInstance().getByKey("modules.asedit.gui.projectsselect.btn.back");
        }));
        int fX = this.width - rW < 200 ? lX + rW + (this.width - lX - rW) / 2 - btnW / 2 : lX - (this.width - lX - rW) / 2 - btnW / 2;
        int fY = this.width - rW < 200 ? lH - 2 - 25 : lH - 2;
        this.addWidget(new TmUpdateButton(fX, fY, btnW, 20, btn -> {
            File file;
            if (btn != null && (file = new File(this.dir)).exists()) {
                Util.func_110647_a().func_195641_a(file);
            }
            return TextUtil.getInstance().getByKey("modules.asedit.gui.projectsselect.btn.folder");
        }));
        this.infoBg = new TmBackgroundWidget((int)((float)this.width * 0.2f), (int)((float)this.height * 0.3f), (int)((float)this.width * 0.6f), (int)((float)this.height * 0.2f), -805306368);
        this.info = new TmTextWidget(this.width / 2, (int)((float)this.height * 0.4f), "", -1);
    }

    private void updateList() {
        this.list.clearWithoutCheck();
        for (AsEditProject proj : this.loadProjects()) {
            this.list.addItem(new ProjectItem(proj, this::onceLoad, this::onceDelete, this::onceUpdate));
        }
        this.list.updateItems();
    }

    private AsEditProject[] loadProjects() {
        File f = new File(this.dir);
        f.mkdirs();
        return (AsEditProject[])Arrays.stream(f.listFiles()).map(i -> {
            Optional<EnumProjectVersion> optLoader = this.module.getPjManager().getLoaderForFile((File)i);
            if (!optLoader.isPresent()) {
                return null;
            }
            Optional<AsEditProject> optProj = optLoader.get().getLoader().loadProperties((File)i);
            return optProj.isPresent() ? optProj.get() : new AsEditProject.InvalidArmorStandProject((File)i);
        }).filter(i -> i != null).toArray(AsEditProject[]::new);
    }

    private void onceLoad(AsEditProject project) {
        if (!this.module.getPjManager().loadProject(project)) {
            this.displayInfo("modules.asedit.gui.projectsselect.load.failed");
        } else {
            TextUtil.getInstance().sendMessage("modules.asedit.gui.projectsselect.load.succes", project.getName(20));
            this.module.guis.update();
        }
    }

    private void onceUpdate(AsEditProject project) {
        Optional<String> optError = project.convertProject();
        if (optError.isPresent()) {
            this.displayInfo(optError.get());
        } else {
            this.updateList();
        }
    }

    private void onceDelete(AsEditProject project) {
        if (!project.delete()) {
            this.displayInfo("modules.asedit.gui.projectsselect.delete.failed");
        }
        this.updateList();
    }

    private void displayInfo(String key) {
        this.millis = System.currentTimeMillis();
        this.removeWidget(this.infoBg);
        this.removeWidget(this.info);
        this.addWidget(this.infoBg);
        this.addWidget(this.info);
        this.info.setTextByKey(key, new Object[0]);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderDirtBackground(0);
        this.fillGradient(0, 58, this.width, this.height, -1072689136, -804253680);
        if (this.millis != -1L && this.millis + 3000L < System.currentTimeMillis()) {
            this.millis = -1L;
            this.removeWidget(this.info);
            this.removeWidget(this.infoBg);
        }
        super.render(mouseX, mouseY, partialTicks);
    }
}

