/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.module.defined.special.asedit.gui.defined;

import de.whiletrue.toolsmod.gui.widgets.TmBackgroundWidget;
import de.whiletrue.toolsmod.gui.widgets.TmItemButton;
import de.whiletrue.toolsmod.gui.widgets.TmTextWidget;
import de.whiletrue.toolsmod.gui.widgets.TmTextfield;
import de.whiletrue.toolsmod.gui.widgets.TmUpdateButton;
import de.whiletrue.toolsmod.gui.widgets.rounding.GuiNode;
import de.whiletrue.toolsmod.module.defined.special.asedit.EditableArmorStand;
import de.whiletrue.toolsmod.module.defined.special.asedit.EnumEditStandEquip;
import de.whiletrue.toolsmod.module.defined.special.asedit.gui.AsEditToggleButton;
import de.whiletrue.toolsmod.module.defined.special.asedit.gui.GuiAsEdit;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GuiAsEditSettings
extends GuiAsEdit {
    @Nullable
    private EditableArmorStand stand;
    private EnumEditStandEquip slot = EnumEditStandEquip.MAINHAND;
    private AsEditToggleButton[] toggleButtons = new AsEditToggleButton[]{new AsEditToggleButton(s -> !s.getAttr(8), (s, b) -> s.setAttr(8, !b), "baseplate"), new AsEditToggleButton(s -> s.getAttr(4), (s, b) -> s.setAttr(4, b), "arms"), new AsEditToggleButton(s -> s.getAttr(1), (s, b) -> s.setAttr(1, b), "small"), new AsEditToggleButton(s -> !s.func_189652_ae(), (s, b) -> s.func_189654_d(!b), "gravity"), new AsEditToggleButton(s -> !s.func_82150_aj(), (s, b) -> s.func_82142_c(!b), "visible"), new AsEditToggleButton(s -> !s.func_190530_aW(), (s, b) -> s.func_184224_h(!b), "vulnerable"), new AsEditToggleButton(s -> s.areSlotsDisabled(), (s, b) -> s.setDisabledSlots(b), "disabledslots"), new AsEditToggleButton(s -> s.isGlowingNatrual(), (s, b) -> s.func_184195_f(b), "glowing")};

    public GuiAsEditSettings() {
        super("settings.name");
    }

    @Override
    protected void init() {
        super.init();
        this.stand = this.manager.getSelectedStand();
        if (this.overlayWidth > 400) {
            this.appendList();
        }
        if (this.stand != null) {
            this.initSingle();
        } else {
            this.initMulti();
        }
    }

    private void initMulti() {
        GuiNode settingsNode = this.addSettingsButtons(105, (btn, set) -> {
            Map<Boolean, List<EditableArmorStand>> values = this.manager.getStands().stream().filter(i -> i.isSelected()).collect(Collectors.groupingBy(btn::get));
            int plus = values.containsKey(true) ? values.get(true).size() : 0;
            int minus = values.containsKey(false) ? values.get(false).size() : 0;
            boolean positive = plus >= minus;
            float perc = (float)(positive ? plus : minus) / (float)(plus + minus);
            if (set) {
                boolean wrapper = positive;
                this.manager.getStands().stream().filter(i -> i.isSelected()).forEach(i -> btn.set((EditableArmorStand)((Object)((Object)i)), !wrapper));
                positive = !positive;
                perc = 1.0f;
            }
            return String.format("%s \u00a7%c %d%%", TextUtil.getInstance().getByKey("modules.asedit.gui.settings.settings." + btn.getName()), Character.valueOf(positive ? (char)'2' : (char)'4'), (int)(perc * 100.0f));
        });
        GuiNode equipNode = this.addEquipButtons((slot, item) -> this.manager.getStands().forEach(i -> i.func_184201_a(slot, item.func_77946_l())));
        int spaceX = (this.overlayWidth - equipNode.getWidth() - settingsNode.getWidth()) / 3;
        settingsNode.init(this.overlayX + spaceX, this.height / 2 - settingsNode.getHeight() / 2);
        equipNode.init(this.overlayX + spaceX * 2 + settingsNode.getWidth(), this.height / 2 - equipNode.getHeight() / 2);
    }

    private GuiNode addSettingsButtons(int btnWidth, IUpdate onExec) {
        int btnAmount = this.toggleButtons.length;
        int btnSpaceY = MathHelper.func_76125_a((int)((this.height - 30 - 20 * btnAmount) / (btnAmount - 1)), (int)0, (int)14);
        int w = btnWidth + 10;
        int h = btnAmount * (20 + btnSpaceY) + 20;
        return new GuiNode(w, h, (x, y) -> {
            this.addWidget(new TmBackgroundWidget(x, y, w, h, -1610612736).setOutline(-16777216, 1));
            this.addWidget(new TmTextWidget(x + w / 2, y + 10, TextUtil.getInstance().getByKey("modules.asedit.gui.settings.settings"), -1));
            for (int i = 0; i < this.toggleButtons.length; ++i) {
                AsEditToggleButton toggle = this.toggleButtons[i];
                this.addWidget(new TmUpdateButton(x + 5, y + 20 + (20 + btnSpaceY) * i + btnSpaceY / 2, btnWidth, 20, btn -> onExec.execute(toggle, btn != null)));
            }
        });
    }

    private GuiNode addEquipButtons(IEquip onEquip) {
        int w = 120;
        int h = 165;
        return new GuiNode(120.0f, 165.0f, (x, y) -> {
            this.addWidget(new TmBackgroundWidget(x, y, 120, 165, -1610612736).setOutline(-16777216, 1));
            this.addWidget(new TmTextWidget(x + 60, y + 10, TextUtil.getInstance().getByKey("modules.asedit.gui.settings.equip"), -1));
            for (int i = 0; i < EnumEditStandEquip.values().length; ++i) {
                EnumEditStandEquip slot = EnumEditStandEquip.values()[i];
                if (i > 0) {
                    this.addWidget(new TmItemButton(x + 60 - slot.getOffsetX() - 50, y + 82 + 20 + slot.getOffsetY(), slot.getIcon(), btn -> {
                        this.slot = slot;
                        this.module.guis.update();
                    }).setEnabled(this.slot != slot).setTooltipp(slot.getName()));
                }
                this.addWidget(new TmItemButton(x + 60 + slot.getOffsetX() + 30, y + 82 + 20 + slot.getOffsetY(), slot.getIcon(), btn -> onEquip.execute(this.slot.getResponse(), slot.getFromSlot((PlayerEntity)this.minecraft.field_71439_g).func_77946_l())).setTooltipp(slot.getCopy()));
            }
        });
    }

    private void initSingle() {
        GuiNode settingsNode = this.addSettingsButtons(95, (btn, set) -> {
            if (set) {
                btn.reverse(this.stand);
            }
            boolean state = btn.get(this.stand);
            return TextUtil.getInstance().offMultiple(" \u00a7" + (state ? (char)'2' : (char)'4'), "modules.asedit.gui.settings.settings." + btn.getName(), "modules.asedit.gui.settings.settings." + (state ? "on" : "off"));
        });
        GuiNode nameFieldNode = this.addNameField();
        GuiNode equipNode = this.addEquipButtons((arg_0, arg_1) -> ((EditableArmorStand)this.manager.getSelectedStand()).func_184201_a(arg_0, arg_1));
        int big = Math.max(nameFieldNode.getWidth(), equipNode.getWidth());
        int spaceX = (this.overlayWidth - settingsNode.getWidth() - big) / 3;
        int spaceY = (this.height - nameFieldNode.getHeight() - equipNode.getHeight()) / 3;
        settingsNode.init(this.overlayX + spaceX, this.height / 2 - settingsNode.getHeight() / 2);
        equipNode.init(this.overlayX + settingsNode.getWidth() + spaceX * 2 + big / 2 - equipNode.getWidth() / 2, spaceY);
        nameFieldNode.init(this.overlayX + settingsNode.getWidth() + spaceX * 2 + big / 2 - nameFieldNode.getWidth() / 2, spaceY * 2 + equipNode.getHeight());
    }

    private GuiNode addNameField() {
        int nfW = (int)Math.min(120.0f, (float)this.overlayWidth * 0.4f);
        int nfBtnW = 60;
        int nfBtnH = 20;
        int w = nfW + 20;
        int h = 75;
        return new GuiNode(w, 75.0f, (x, y) -> {
            this.addWidget(new TmBackgroundWidget(x, y, w, 75, -1610612736).setOutline(-16777216, 1));
            this.addWidget(new TmTextWidget(x + w / 2, y + 10, TextUtil.getInstance().getByKey("modules.asedit.gui.settings.settings.name"), -1));
            TmTextfield nameField = new TmTextfield(x + 5, y + 30, w - 10, 15, "", null);
            nameField.setText(this.stand.func_145818_k_() ? this.stand.func_200201_e().getString() : "");
            nameField.setResponder(name -> this.stand.func_200203_b((ITextComponent)(name.isEmpty() ? null : new StringTextComponent(name))));
            this.addWidget(nameField);
            this.addWidget(new TmUpdateButton(x + w / 2 - 30, y + 75 - 25, 60, 20, btn -> {
                if (btn != null) {
                    this.stand.func_174805_g(!this.stand.func_174833_aM());
                }
                return TextUtil.getInstance().offMultiple(" \u00a7" + (this.stand.func_174833_aM() ? (char)'2' : (char)'4'), "modules.asedit.gui.settings.settings.customnamevisible", "modules.asedit.gui.settings.settings." + (this.stand.func_174833_aM() ? "on" : "off"));
            }));
        });
    }

    @FunctionalInterface
    private static interface IUpdate {
        public String execute(AsEditToggleButton var1, boolean var2);
    }

    @FunctionalInterface
    private static interface IEquip {
        public void execute(EquipmentSlotType var1, ItemStack var2);
    }
}

