/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.module.defined.special.asedit.projects;

import de.whiletrue.toolsmod.module.defined.special.asedit.EditableArmorStand;
import de.whiletrue.toolsmod.module.defined.special.asedit.projects.EnumProjectVersion;
import java.io.File;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;

public class AsEditProject {
    private File file;
    private String author;
    private String name;
    private String projectVersion;
    private EnumProjectVersion loaderVersion;

    public AsEditProject(String fileName, String name) {
        this.file = new File("toolsmod/assaves/", fileName + '.' + EnumProjectVersion.NEWEST.getExtension());
        this.author = Minecraft.func_71410_x().func_110432_I().func_111285_a();
        this.loaderVersion = EnumProjectVersion.NEWEST;
        this.name = name;
        this.projectVersion = "v1";
    }

    public AsEditProject(File file, String name, String author, String projectVersion, EnumProjectVersion version) {
        this.file = file;
        this.author = author;
        this.loaderVersion = version;
        this.name = name;
        this.projectVersion = projectVersion;
    }

    public Optional<String> saveProject(EditableArmorStand[] stands) {
        boolean saved = this.getVersion().getLoader().saveProject(this, stands, this.getFile(), Minecraft.func_71410_x().field_71439_g.func_180425_c());
        return Optional.ofNullable(saved ? null : "module.asedit.general.project.save.error");
    }

    public Optional<String> convertProject() {
        BlockPos pos = new BlockPos(0, 0, 0);
        Optional<EditableArmorStand[]> optStands = this.getVersion().getLoader().loadProject(this.getFile(), pos);
        if (!optStands.isPresent()) {
            return Optional.of("modules.asedit.gui.projectsselect.convert.load");
        }
        File file = this.getNextFile();
        EnumProjectVersion.NEWEST.getLoader().saveProject(this, optStands.get(), file, pos);
        boolean del = this.getFile().delete();
        if (del) {
            this.file = file;
            this.loaderVersion = EnumProjectVersion.NEWEST;
            return Optional.empty();
        }
        return Optional.of("modules.asedit.gui.projectsselect.convert.failed");
    }

    @Nullable
    public EditableArmorStand[] loadProject() {
        Optional<EditableArmorStand[]> optLoad = this.getVersion().getLoader().loadProject(this.getFile(), Minecraft.func_71410_x().field_71439_g.func_180425_c());
        if (!optLoad.isPresent() || optLoad.get().length <= 0) {
            return null;
        }
        return optLoad.get();
    }

    public File getNextFile() {
        String path = this.getFile().getAbsolutePath().substring(0, this.getFile().getAbsolutePath().length() - this.getFile().getName().length());
        String name = this.getFile().getName().substring(0, this.getFile().getName().length() - this.getVersion().getExtension().length() - 1);
        EnumProjectVersion v = EnumProjectVersion.NEWEST;
        for (int c = 0; c < 20000; ++c) {
            File file = new File(path, name + (c == 0 ? "" : String.valueOf(c)) + "." + v.getExtension());
            if (file.exists()) continue;
            return file;
        }
        return new File(path, name + "." + v.getExtension());
    }

    public void reload() {
        Optional<AsEditProject> project = this.getVersion().getLoader().loadProperties(this.file);
        if (project.isPresent()) {
            AsEditProject proj = project.get();
            this.name = proj.getName(-1);
            this.author = proj.getAuthor(-1);
            this.projectVersion = proj.getVersion(-1);
        }
    }

    public boolean delete() {
        return this.file.delete();
    }

    public File getFile() {
        return this.file;
    }

    public EnumProjectVersion getVersion() {
        return this.loaderVersion;
    }

    public String getName(int length) {
        return length != -1 && this.name.length() >= length ? this.name.substring(0, length - 2) + "..." : this.name;
    }

    public String getAuthor(int length) {
        return length != -1 && this.author.length() >= length ? this.author.substring(0, length - 2) + "..." : this.author;
    }

    public String getVersion(int length) {
        return length != -1 && this.projectVersion.length() >= length ? this.projectVersion.substring(0, length - 2) + "..." : this.projectVersion;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public static class InvalidArmorStandProject
    extends AsEditProject {
        public InvalidArmorStandProject(File file) {
            super(file, null, null, null, null);
        }
    }
}

