/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.settings.defined;

import de.whiletrue.toolsmod.module.defined.Module;
import de.whiletrue.toolsmod.settings.Setting;
import de.whiletrue.toolsmod.settings.views.SettingView;
import de.whiletrue.toolsmod.settings.views.SettingViewEnum;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;

public class SettingEnum<Enm extends Enum<?>>
extends Setting<Enm> {
    private Function<Enm, String> onIdentify;
    private Function<Enm, String> onDisplay;

    public SettingEnum(Function<Enm, String> onIdentify, Function<Enm, String> onDisplay) {
        this.onIdentify = onIdentify;
        this.onDisplay = onDisplay;
    }

    @Override
    public String handleSave() {
        return this.onIdentify.apply(this.value);
    }

    @Override
    public boolean handleParse(String value) {
        Optional<Enum> x = Arrays.stream(((Enum)this.value).getDeclaringClass().getEnumConstants()).filter(i -> this.onIdentify.apply(i).equals(value)).findFirst();
        x.ifPresent(i -> {
            this.value = (Enum)i;
        });
        return x.isPresent();
    }

    public Function<Enm, String> getOnDisplay() {
        return this.onDisplay;
    }

    public Function<Enm, String> getOnIdentify() {
        return this.onIdentify;
    }

    @Override
    public <X extends Setting<Enm>> SettingView<X> getView(Module mod) {
        return new SettingViewEnum(this, mod);
    }
}

