/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.settings.defined;

import de.whiletrue.toolsmod.module.defined.Module;
import de.whiletrue.toolsmod.settings.Setting;
import de.whiletrue.toolsmod.settings.views.SettingView;
import de.whiletrue.toolsmod.settings.views.SettingViewFloatSlider;
import de.whiletrue.toolsmod.settings.views.SettingViewFloatTextfield;

public class SettingFloat
extends Setting<Float> {
    private Integer maxDecimalPlaces;
    private Float max;
    private Float min;
    private String suffix;

    public SettingFloat max(float value) {
        this.max = Float.valueOf(value);
        return this;
    }

    public SettingFloat min(float value) {
        this.min = Float.valueOf(value);
        return this;
    }

    public SettingFloat maxDecimalPlaces(int places) {
        this.maxDecimalPlaces = places;
        return this;
    }

    public SettingFloat slider(String suffix) {
        this.suffix = suffix;
        return this;
    }

    @Override
    public String handleSave() {
        return ((Float)this.value).toString();
    }

    @Override
    public boolean handleParse(String value) {
        try {
            Float val = Float.valueOf(value);
            if (this.max != null && val.floatValue() > this.max.floatValue()) {
                return false;
            }
            if (this.min != null && val.floatValue() < this.min.floatValue()) {
                return false;
            }
            this.setValue(Float.valueOf(value).floatValue());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setValue(float value) {
        if (this.maxDecimalPlaces != null) {
            long pow = (long)Math.pow(10.0, this.maxDecimalPlaces.intValue());
            this.value = Float.valueOf((float)((int)(value * (float)pow)) / (float)pow);
        } else {
            this.value = Float.valueOf(value);
        }
    }

    public Float getMax() {
        return this.max;
    }

    public Float getMin() {
        return this.min;
    }

    public Integer getMaxDecimalPlaces() {
        return this.maxDecimalPlaces;
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public <X extends Setting<Float>> SettingView<X> getView(Module mod) {
        if (this.suffix != null && this.min != null && this.max != null) {
            return new SettingViewFloatSlider(this, mod);
        }
        return new SettingViewFloatTextfield(this, mod);
    }
}

