/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.settings.views;

import de.whiletrue.toolsmod.gui.widgets.TmTextWidget;
import de.whiletrue.toolsmod.gui.widgets.rounding.listscaleable.ScaleableListItem;
import de.whiletrue.toolsmod.module.defined.Module;
import de.whiletrue.toolsmod.settings.Setting;
import de.whiletrue.toolsmod.util.TextAlign;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import javax.annotation.Nullable;

public abstract class SettingView<T extends Setting<?>>
extends ScaleableListItem<T> {
    private TmTextWidget title;
    private String titleString;

    public SettingView(T item, @Nullable Module mod) {
        super(item);
        this.titleString = TextUtil.getInstance().getByKey(mod != null ? "settings." + mod.getName().toLowerCase() + '.' + ((Setting)item).getName() : "global.settings." + ((Setting)item).getName());
        this.title = new TmTextWidget(0, 0, "", -1).setAlignX(TextAlign.BEFORE).setText(this.titleString);
        this.widgets.add(this.title);
    }

    @Override
    public int handleChangePosition(int x, int w) {
        super.handleChangePosition(x, w);
        this.title.setX(x);
        return 10;
    }

    @Override
    public void handleChangePositionScrolled(int y) {
        super.handleChangePositionScrolled(y);
        this.title.setY(y);
    }

    public boolean isValid(String search) {
        return this.titleString.toLowerCase().contains(search.toLowerCase());
    }
}

