/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.update;

public enum ChangeType {
    REMOVE(0, "Removed", 0xFF5555),
    ADD(1, "Added", 0x55FF55),
    EDIT(2, "Reworked", 0xFFAA00);

    private int id;
    private String description;
    private int color;

    private ChangeType(int id, String description, int color) {
        this.id = id;
        this.description = description;
        this.color = color | 0xFF000000;
    }

    public String getDescription() {
        return this.description;
    }

    public int getId() {
        return this.id;
    }

    public int getColor() {
        return this.color;
    }

    public static ChangeType getFromId(int id) {
        for (ChangeType c : ChangeType.values()) {
            if (c.id != id) continue;
            return c;
        }
        return REMOVE;
    }
}

