/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.update;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import de.whiletrue.toolsmod.update.ChangeType;
import de.whiletrue.toolsmod.update.LogEntry;
import de.whiletrue.toolsmod.util.classes.FileUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.stream.StreamSupport;
import net.minecraft.util.ResourceLocation;

public class Changelog {
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("MM/dd/yyyy");
    private Date releaseDate;
    private LogEntry[] entries;

    public Changelog() {
        ResourceLocation rsc = new ResourceLocation("toolsmod", "changelog.json");
        try {
            JsonObject log = FileUtil.getInstance().loadFromRSCAsJson(rsc).get().getAsJsonObject();
            this.releaseDate = DATE_FORMATTER.parse(log.get("release").getAsString());
            JsonArray changes = log.get("changes").getAsJsonArray();
            LogEntry[] entries = (LogEntry[])StreamSupport.stream(changes.spliterator(), false).map(i -> {
                try {
                    JsonObject val = i.getAsJsonObject();
                    return new LogEntry(val.get("feature").getAsString(), val.get("desc").getAsString(), ChangeType.getFromId(val.get("type").getAsInt()));
                }
                catch (Exception e) {
                    return null;
                }
            }).filter(i -> i != null).toArray(LogEntry[]::new);
            if (entries.length != changes.size()) {
                throw new Exception("Invalid entrys found: " + entries.length + '/' + changes.size());
            }
            this.entries = entries;
        }
        catch (Exception e) {
            System.out.println("Failed to load the change log: " + e.getMessage());
        }
    }

    public boolean isLoaded() {
        return this.entries != null;
    }

    public LogEntry[] getEntries() {
        return this.entries;
    }

    public String getReleaseDate() {
        return DATE_FORMATTER.format(this.releaseDate);
    }
}

