/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class PlayerProfile {
    private String name;
    private String uuid;
    private List<Name> previousNames;

    public PlayerProfile(String name, String uuid, List<Name> previousNames) {
        this.name = name;
        this.uuid = uuid;
        this.previousNames = previousNames;
    }

    public String getName() {
        return this.name;
    }

    public String getUuid() {
        return this.uuid;
    }

    public List<Name> getPreviousNames() {
        return this.previousNames;
    }

    public static class Name {
        private String name;
        private long changeDate;

        public Name(String name, long changeDate) {
            this.name = name;
            this.changeDate = changeDate;
        }

        public String getName() {
            return this.name;
        }

        public long getChangeDate() {
            return this.changeDate;
        }

        public Optional<String> formattedDate() {
            if (this.changeDate == -1L) {
                return Optional.empty();
            }
            return Optional.of(new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(new Date(this.changeDate)));
        }
    }
}

