/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.util.classes;

import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CCreativeInventoryActionPacket;
import net.minecraft.util.registry.Registry;

public class ItemUtil {
    private static ItemUtil instance;

    private ItemUtil() {
    }

    public static ItemUtil getInstance() {
        if (instance == null) {
            instance = new ItemUtil();
        }
        return instance;
    }

    public Optional<CompoundNBT> stringToNbt(String nbt) {
        try {
            return Optional.of(JsonToNBT.func_180713_a((String)nbt));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public boolean setItem(ItemStack item) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71442_b.func_78762_g()) {
            return false;
        }
        int slot = mc.field_71439_g.field_71071_by.field_70461_c + 36;
        mc.field_71439_g.field_71071_by.func_70299_a(mc.field_71439_g.field_71071_by.field_70461_c, item);
        CCreativeInventoryActionPacket packet = new CCreativeInventoryActionPacket(slot, item);
        mc.field_71439_g.field_71174_a.func_147297_a((IPacket)packet);
        return true;
    }

    public Optional<Item> getItemFromName(String raw) {
        if (!raw.contains(":")) {
            return this.getItemFromName("minecraft", raw);
        }
        String reg = raw.substring(0, raw.indexOf(":"));
        String itm = raw.substring(raw.indexOf(":") + 1);
        return this.getItemFromName(reg, itm);
    }

    public Optional<Item> getItemFromName(String registry, String name) {
        return Registry.field_212630_s.func_201756_e().filter(i -> i.func_77658_a().endsWith(registry + "." + name.toLowerCase())).findFirst();
    }

    public Optional<Block> getBlockFromName(String raw) {
        if (!raw.contains(":")) {
            return this.getBlockFromName("minecraft", raw);
        }
        String reg = raw.substring(0, raw.indexOf(":"));
        String itm = raw.substring(raw.indexOf(":") + 1);
        return this.getBlockFromName(reg, itm);
    }

    public Optional<Block> getBlockFromName(String registry, String name) {
        return Registry.field_212618_g.func_201756_e().filter(i -> i.func_149739_a().endsWith(registry + '.' + name)).findFirst();
    }

    public CompoundNBT getTagFromArmorstand(ArmorStandEntity entity) {
        String[] toRem;
        CompoundNBT nbt = new CompoundNBT();
        entity.func_70039_c(nbt);
        for (String s : toRem = new String[]{"Brain", "UUIDMost", "UUIDLeast", "Air", "Dimension", "HurtByTimestamp", "Attributes", "FallFlying", "PortalCooldown", "AbsorptionAmount", "FallDistance", "DeathTime", "Motion", "Health", "OnGround", "HurtTime"}) {
            nbt.func_82580_o(s);
        }
        return nbt;
    }
}

