/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.util.classes;

import de.whiletrue.toolsmod.util.classes.ReflectionUtil;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.Optional;

public class JavaUtil {
    private static JavaUtil instance;

    private JavaUtil() {
    }

    public static JavaUtil getInstance() {
        if (instance == null) {
            instance = new JavaUtil();
        }
        return instance;
    }

    public <T extends Enum<?>> T getEnumPre(T value) {
        Enum[] presets = (Enum[])value.getDeclaringClass().getEnumConstants();
        for (int i = 0; i < presets.length; ++i) {
            if (presets[i] != value) continue;
            return (T)(i - 1 < 0 ? presets[presets.length - 1] : presets[i - 1]);
        }
        return value;
    }

    public <T extends Enum<?>> T getEnumNext(T value) {
        Enum[] presets = (Enum[])value.getDeclaringClass().getEnumConstants();
        for (int i = 0; i < presets.length; ++i) {
            if (presets[i] != value) continue;
            return (T)(i + 1 == presets.length ? presets[0] : presets[i + 1]);
        }
        return value;
    }

    public boolean isDouble(String s) {
        try {
            Double.valueOf(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isInt(String s) {
        try {
            Integer.valueOf(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isFloat(String s) {
        try {
            Float.valueOf(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Optional<Color> getColorFromString(String value) {
        Optional<Field> optField = ReflectionUtil.getInstance().get(Color.class, value);
        if (optField.isPresent()) {
            return ReflectionUtil.getInstance().get(optField.get(), null);
        }
        try {
            return Optional.of(Color.decode(value));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }
}

