/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.util.classes;

import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.Agent;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import de.whiletrue.toolsmod.util.PlayerProfile;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Session;

public class MojangUtils {
    private static MojangUtils instance;

    private MojangUtils() {
    }

    public static MojangUtils getInstance() {
        if (instance == null) {
            instance = new MojangUtils();
        }
        return instance;
    }

    public Optional<PlayerProfile> getPlayerProfile(String username) {
        try {
            JsonObject data = new JsonParser().parse((Reader)new InputStreamReader(new URL("https://api.mojang.com/users/profiles/minecraft/" + username).openStream())).getAsJsonObject();
            String name = data.get("name").getAsString();
            String uuid = data.get("id").getAsString();
            JsonArray allNames = new JsonParser().parse((Reader)new InputStreamReader(new URL("https://api.mojang.com/user/profiles/" + uuid + "/names").openStream())).getAsJsonArray();
            List<PlayerProfile.Name> previousNames = Streams.stream((Iterable)allNames).map(i -> {
                JsonObject obj = i.getAsJsonObject();
                return new PlayerProfile.Name(obj.get("name").getAsString(), obj.has("changedToAt") ? obj.get("changedToAt").getAsLong() : -1L);
            }).collect(Collectors.toList());
            return Optional.of(new PlayerProfile(name, uuid, previousNames));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public boolean login(String username, String password) {
        try {
            YggdrasilUserAuthentication auth = new YggdrasilUserAuthentication(new YggdrasilAuthenticationService(Minecraft.func_71410_x().func_110437_J(), UUID.randomUUID().toString()), Agent.MINECRAFT);
            auth.setUsername(username);
            auth.setPassword(password);
            auth.logIn();
            Session session = new Session(auth.getSelectedProfile().getName(), auth.getSelectedProfile().getId().toString(), auth.getAuthenticatedToken(), username.contains("@") ? "mojang" : "legacy");
            Field f = Minecraft.class.getField("session");
            f.set(Minecraft.func_71410_x(), session);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void login(String username) {
        try {
            Field f = Session.class.getField("username");
            f.set(Minecraft.func_71410_x().func_110432_I(), username);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

