/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.util.classes;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class RenderUtil {
    private static RenderUtil instance;
    private Minecraft mc = Minecraft.func_71410_x();

    private RenderUtil() {
    }

    public static RenderUtil getInstance() {
        if (instance == null) {
            instance = new RenderUtil();
        }
        return instance;
    }

    public void renderOutline(int x, int y, int width, int height, int outlineStrength, int outlineColor) {
        this.renderRect(x, y, width, outlineStrength, outlineColor);
        this.renderRect(x, y + height - outlineStrength, width, outlineStrength, outlineColor);
        this.renderRect(x + width - outlineStrength, y + outlineStrength, outlineStrength, height - outlineStrength * 2, outlineColor);
        this.renderRect(x, y + outlineStrength, outlineStrength, height - outlineStrength * 2, outlineColor);
    }

    public void startScissor(int x, int y, int width, int height) {
        MainWindow win = this.mc.func_228018_at_();
        double scale = win.func_198100_s();
        GL11.glScissor((int)((int)((double)x * scale)), (int)((int)((double)(win.func_198087_p() - y - height) * scale)), (int)((int)((double)width * scale)), (int)((int)((double)height * scale)));
        GL11.glEnable((int)3089);
    }

    public void stopScissor() {
        GL11.glDisable((int)3089);
    }

    public void renderRect(int x, int y, int w, int h, int color) {
        AbstractGui.fill((int)x, (int)y, (int)(x + w), (int)(y + h), (int)color);
    }

    public void renderDirtBackground(int y, int height) {
        int width = this.mc.field_71462_r.width;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        this.mc.func_110434_K().func_110577_a(AbstractGui.BACKGROUND_LOCATION);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_225582_a_(0.0, (double)height + (double)y, 0.0).func_225583_a_(0.0f, (float)height / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
        bufferbuilder.func_225582_a_((double)width, (double)y + (double)height, 0.0).func_225583_a_((float)width / 32.0f, (float)height / 32.0f + 0.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
        bufferbuilder.func_225582_a_((double)width, (double)y, 0.0).func_225583_a_((float)width / 32.0f, 0.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
        bufferbuilder.func_225582_a_(0.0, (double)y, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
        tessellator.func_78381_a();
    }

    public void renderCenteredString(String text, int x, int y, int color) {
        this.mc.field_71466_p.func_175063_a(text, (float)(x - this.mc.field_71466_p.func_78256_a(text) / 2), (float)y, color);
    }

    public void renderItem(ItemStack item, IBakedModel model, int x, int y) {
        boolean flag;
        RenderSystem.pushMatrix();
        this.mc.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        this.mc.func_110434_K().func_229267_b_(PlayerContainer.field_226615_c_).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)x, (float)y, (float)(100.0f + this.mc.func_175599_af().field_77023_b));
        RenderSystem.translatef((float)8.0f, (float)8.0f, (float)0.0f);
        RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        RenderSystem.scalef((float)16.0f, (float)16.0f, (float)16.0f);
        MatrixStack matrixstack = new MatrixStack();
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        boolean bl = flag = !model.func_230044_c_();
        if (flag) {
            RenderHelper.func_227783_c_();
        }
        this.mc.func_175599_af().func_229111_a_(item, ItemCameraTransforms.TransformType.GUI, false, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0, OverlayTexture.field_229196_a_, model);
        irendertypebuffer$impl.func_228461_a_();
        if (flag) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
    }

    public AxisAlignedBB calculateAxisAlign(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
        Vec3d pos = this.mc.field_71438_f.field_174995_M.func_217671_b();
        return new AxisAlignedBB(x - pos.func_82615_a(), y - pos.func_82617_b(), z - pos.func_82616_c(), x - pos.func_82615_a() + sizeX, y - pos.func_82617_b() + sizeY, z - pos.func_82616_c() + sizeZ);
    }

    public void renderBlockOverlay(double x, double y, double z, double size) {
        Vec3d pos = this.mc.field_71438_f.field_174995_M.func_217671_b();
        AxisAlignedBB coord = new AxisAlignedBB(x - pos.func_82615_a() + 0.5 - 0.5 * size, y - pos.func_82617_b() + 0.5 - 0.5 * size, z - pos.func_82616_c() + 0.5 - 0.5 * size, x - pos.func_82615_a() + 1.0 * size, y - pos.func_82617_b() + 1.0 * size, z - pos.func_82616_c() + 1.0 * size);
        this.renderBlockOverlay(coord);
    }

    public void renderBlockOverlay(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        Vec3d pos = this.mc.field_71438_f.field_174995_M.func_217671_b();
        double iX = Math.min(minX, maxX) - pos.field_72450_a;
        double iY = Math.min(minY, maxY) - pos.field_72448_b;
        double iZ = Math.min(minZ, maxZ) - pos.field_72449_c;
        double aX = Math.max(minX, maxX) - pos.field_72450_a;
        double aY = Math.max(minY, maxY) - pos.field_72448_b;
        double aZ = Math.max(minZ, maxZ) - pos.field_72449_c;
        Tessellator ts = Tessellator.func_178181_a();
        BufferBuilder wr = ts.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        wr.func_225582_a_(iX, iY, iZ).func_181675_d();
        wr.func_225582_a_(iX, aY, iZ).func_181675_d();
        wr.func_225582_a_(aX, aY, iZ).func_181675_d();
        wr.func_225582_a_(aX, iY, iZ).func_181675_d();
        ts.func_78381_a();
        wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        wr.func_225582_a_(iX, aY, iZ).func_181675_d();
        wr.func_225582_a_(iX, aY, aZ).func_181675_d();
        wr.func_225582_a_(aX, aY, aZ).func_181675_d();
        wr.func_225582_a_(aX, aY, iZ).func_181675_d();
        ts.func_78381_a();
        wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        wr.func_225582_a_(iX, iY, iZ).func_181675_d();
        wr.func_225582_a_(iX, iY, aZ).func_181675_d();
        wr.func_225582_a_(iX, aY, aZ).func_181675_d();
        wr.func_225582_a_(iX, aY, iZ).func_181675_d();
        ts.func_78381_a();
        wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        wr.func_225582_a_(iX, iY, iZ).func_181675_d();
        wr.func_225582_a_(aX, iY, iZ).func_181675_d();
        wr.func_225582_a_(aX, iY, aZ).func_181675_d();
        wr.func_225582_a_(iX, iY, aZ).func_181675_d();
        ts.func_78381_a();
        wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        wr.func_225582_a_(iX, iY, aZ).func_181675_d();
        wr.func_225582_a_(aX, iY, aZ).func_181675_d();
        wr.func_225582_a_(aX, aY, aZ).func_181675_d();
        wr.func_225582_a_(iX, aY, aZ).func_181675_d();
        ts.func_78381_a();
        wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        wr.func_225582_a_(aX, iY, aZ).func_181675_d();
        wr.func_225582_a_(aX, iY, iZ).func_181675_d();
        wr.func_225582_a_(aX, aY, iZ).func_181675_d();
        wr.func_225582_a_(aX, aY, aZ).func_181675_d();
        ts.func_78381_a();
    }

    public void renderBlockOverlay(AxisAlignedBB block) {
        Tessellator ts = Tessellator.func_178181_a();
        BufferBuilder wr = ts.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        wr.func_225582_a_(block.field_72340_a, block.field_72338_b, block.field_72339_c).func_181675_d();
        wr.func_225582_a_(block.field_72340_a, block.field_72337_e, block.field_72339_c).func_181675_d();
        wr.func_225582_a_(block.field_72336_d, block.field_72337_e, block.field_72339_c).func_181675_d();
        wr.func_225582_a_(block.field_72336_d, block.field_72338_b, block.field_72339_c).func_181675_d();
        ts.func_78381_a();
        wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        wr.func_225582_a_(block.field_72340_a, block.field_72337_e, block.field_72339_c).func_181675_d();
        wr.func_225582_a_(block.field_72340_a, block.field_72337_e, block.field_72334_f).func_181675_d();
        wr.func_225582_a_(block.field_72336_d, block.field_72337_e, block.field_72334_f).func_181675_d();
        wr.func_225582_a_(block.field_72336_d, block.field_72337_e, block.field_72339_c).func_181675_d();
        ts.func_78381_a();
        wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        wr.func_225582_a_(block.field_72340_a, block.field_72338_b, block.field_72339_c).func_181675_d();
        wr.func_225582_a_(block.field_72340_a, block.field_72338_b, block.field_72334_f).func_181675_d();
        wr.func_225582_a_(block.field_72340_a, block.field_72337_e, block.field_72334_f).func_181675_d();
        wr.func_225582_a_(block.field_72340_a, block.field_72337_e, block.field_72339_c).func_181675_d();
        ts.func_78381_a();
        wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        wr.func_225582_a_(block.field_72340_a, block.field_72338_b, block.field_72339_c).func_181675_d();
        wr.func_225582_a_(block.field_72336_d, block.field_72338_b, block.field_72339_c).func_181675_d();
        wr.func_225582_a_(block.field_72336_d, block.field_72338_b, block.field_72334_f).func_181675_d();
        wr.func_225582_a_(block.field_72340_a, block.field_72338_b, block.field_72334_f).func_181675_d();
        ts.func_78381_a();
        wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        wr.func_225582_a_(block.field_72340_a, block.field_72338_b, block.field_72334_f).func_181675_d();
        wr.func_225582_a_(block.field_72336_d, block.field_72338_b, block.field_72334_f).func_181675_d();
        wr.func_225582_a_(block.field_72336_d, block.field_72337_e, block.field_72334_f).func_181675_d();
        wr.func_225582_a_(block.field_72340_a, block.field_72337_e, block.field_72334_f).func_181675_d();
        ts.func_78381_a();
        wr.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        wr.func_225582_a_(block.field_72336_d, block.field_72338_b, block.field_72334_f).func_181675_d();
        wr.func_225582_a_(block.field_72336_d, block.field_72338_b, block.field_72339_c).func_181675_d();
        wr.func_225582_a_(block.field_72336_d, block.field_72337_e, block.field_72339_c).func_181675_d();
        wr.func_225582_a_(block.field_72336_d, block.field_72337_e, block.field_72334_f).func_181675_d();
        ts.func_78381_a();
    }

    public void renderImage(ResourceLocation image, int x, int y, int width, int height) {
        this.mc.func_110434_K().func_110577_a(image);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        AbstractGui.blit((int)x, (int)y, (int)0, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
    }
}

