/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.util.classes;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;

public class TextUtil {
    private static TextUtil instance;
    private Minecraft mc = Minecraft.func_71410_x();

    private TextUtil() {
    }

    public static TextUtil getInstance() {
        if (instance == null) {
            instance = new TextUtil();
        }
        return instance;
    }

    public String getPrefix() {
        return String.format("\u00a78[\u00a7%c%s\u00a78] \u00a7%c", Character.valueOf('b'), "Toolsmod", Character.valueOf('6'));
    }

    public String getByKey(String key) {
        return LanguageMap.func_74808_a().func_74805_b("toolsmod." + key);
    }

    public String getByKey(String key, Object ... formatting) {
        try {
            return String.format(this.getByKey(key), formatting);
        }
        catch (Exception e) {
            return "Invalid formatted: " + key;
        }
    }

    public String offMultiple(String splitter, String ... keys) {
        return Arrays.stream(keys).map(this::getByKey).collect(Collectors.joining(splitter));
    }

    public String getByKey(String key, boolean state, String on, String off) {
        return this.getByKey(key + (state ? on : off));
    }

    public void sendMessage(String key, Object ... format) {
        String pref = this.getPrefix();
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)this.appendColors(pref + this.getByKey(key, format)));
    }

    public void sendError(String key, Object ... format) {
        String pref = String.format("\u00a78[\u00a7%c%s\u00a78] \u00a7c", Character.valueOf('b'), "Toolsmod");
        this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)this.appendColors(pref + this.getByKey(key, format)));
    }

    public void sendMessageRaw(String message) {
        String pref = String.format("\u00a78[\u00a7%c%s\u00a78] \u00a7%c", Character.valueOf('b'), "Toolsmod", Character.valueOf('6'));
        this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)this.appendColors(pref + message));
    }

    public void sendEmptyLine() {
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new StringTextComponent(""));
    }

    public TextComponent appendColors(String text) {
        String[] split;
        StringTextComponent fin = new StringTextComponent("");
        StringTextComponent current = new StringTextComponent("");
        for (String s : split = text.split("\u00c2\u00a7")) {
            if (s.length() <= 0) continue;
            char style = s.charAt(0);
            TextFormatting tf = TextFormatting.func_211165_a((char)style);
            if (tf == null) {
                current.func_150258_a(s);
                fin.func_150257_a((ITextComponent)current);
                current = new StringTextComponent("");
                continue;
            }
            TextFormatting color = current.func_150256_b().func_150215_a();
            fin.func_150257_a((ITextComponent)current);
            current = new StringTextComponent(s.substring(1, s.length()));
            if (!tf.func_96302_c()) {
                current.func_211708_a(color);
            }
            current.func_211708_a(tf);
        }
        fin.func_150257_a((ITextComponent)current);
        return fin;
    }

    public String splitStringOnWidth(String text, float minWidth, float maxWidth) {
        String split = "";
        String full = "";
        for (char c : text.toCharArray()) {
            int tw = this.mc.field_71466_p.func_78256_a(split);
            if ((float)tw > minWidth && (c == ' ' || (float)tw > maxWidth)) {
                full = full + "\n" + split;
                if (c != ' ') {
                    split = String.valueOf(c);
                    continue;
                }
                split = "";
                continue;
            }
            split = split + c;
        }
        if ((full = full + "\n" + split).length() > 0) {
            full = full.substring(1);
        }
        return full;
    }

    public String trimStringToWidth(String text, int width, String append) {
        String convert = "";
        for (char c : text.toCharArray()) {
            if (this.mc.field_71466_p.func_78256_a(convert + c) > width) {
                return convert + append;
            }
            convert = convert + c;
        }
        return text;
    }
}

