/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.command;

public class ArgsReturn<T> {
    private T value;
    private String asString;
    private EdgeCodes code;

    public ArgsReturn(T value, String asString) {
        this.value = value;
        this.asString = asString;
    }

    public ArgsReturn(String asString) {
        this.asString = asString;
        this.code = EdgeCodes.PARSE_ERROR;
    }

    public ArgsReturn() {
        this.code = EdgeCodes.ARGUMENT_NOT_PRESENT;
    }

    public T get() {
        return this.value;
    }

    public String getAsString() {
        return this.asString;
    }

    public boolean isPresent() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean isCode(EdgeCodes code) {
        return this.code != null && this.code.equals((Object)code);
    }

    public boolean hasParseError() {
        return this.isCode(EdgeCodes.PARSE_ERROR);
    }

    public boolean hasArgumentError() {
        return this.isCode(EdgeCodes.ARGUMENT_NOT_PRESENT);
    }

    public static enum EdgeCodes {
        ARGUMENT_NOT_PRESENT,
        PARSE_ERROR;

    }
}

