/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.command;

import de.whiletrue.toolsmod.command.ArgsReturn;
import de.whiletrue.toolsmod.mod.Toolsmod;
import de.whiletrue.toolsmod.module.defined.Module;
import de.whiletrue.toolsmod.util.classes.ItemUtil;
import de.whiletrue.toolsmod.util.classes.JavaUtil;
import de.whiletrue.toolsmod.util.classes.ReflectionUtil;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.glfw.GLFW;

public class Arguments {
    private String[] args;
    private Minecraft mc = Minecraft.func_71410_x();

    private Arguments(String[] args) {
        this.args = args;
    }

    public static Arguments of(String ... args) {
        return new Arguments(args);
    }

    private Optional<String> pop() {
        if (this.args.length <= 0) {
            return Optional.empty();
        }
        Optional<String> opt = Optional.ofNullable(this.args[0]);
        this.args = Arrays.copyOfRange(this.args, 1, this.args.length);
        return opt;
    }

    private Optional<String> popLeft() {
        String left = Arrays.stream(this.args).collect(Collectors.joining(" "));
        return left.isEmpty() ? Optional.empty() : Optional.of(left);
    }

    private void push(Optional<String> ... arguments) {
        this.args = (String[])Stream.concat(Arrays.stream(arguments).filter(i -> i.isPresent()).map(i -> (String)i.get()), Arrays.stream(this.args)).toArray(String[]::new);
    }

    private <T> ArgsReturn<T> parser(IParser<T> ex) {
        Optional<String> pop = this.pop();
        if (!pop.isPresent()) {
            this.push(pop);
            return new ArgsReturn();
        }
        Optional<T> get = ex.exec(pop.get());
        if (!get.isPresent()) {
            this.push(pop);
            return new ArgsReturn(pop.get());
        }
        return new ArgsReturn<T>(get.get(), pop.get());
    }

    public ArgsReturn<String> nextOf(String[] allowed) {
        return this.parser(i -> {
            for (String s : allowed) {
                if (!s.equalsIgnoreCase(i)) continue;
                return Optional.of(i);
            }
            return Optional.empty();
        });
    }

    public ArgsReturn<String> nextString() {
        return this.parser(Optional::of);
    }

    public ArgsReturn<String> nextStringleft() {
        Optional<String> left = this.popLeft();
        if (!left.isPresent()) {
            this.push(left);
            return new ArgsReturn<String>();
        }
        return new ArgsReturn<String>(left.get(), left.get());
    }

    public ArgsReturn<BlockPos> nextPosition() {
        Optional<String> sx = this.pop();
        Optional<String> sy = this.pop();
        Optional<String> sz = this.pop();
        if (!(sx.isPresent() && sy.isPresent() && sz.isPresent())) {
            this.push(sx, sy, sz);
            return new ArgsReturn<BlockPos>();
        }
        Optional<Double> optX = this.getPosFromString(sx.get(), this.mc.field_71439_g.func_226277_ct_());
        Optional<Double> optY = this.getPosFromString(sy.get(), this.mc.field_71439_g.func_226278_cu_());
        Optional<Double> optZ = this.getPosFromString(sz.get(), this.mc.field_71439_g.func_226281_cx_());
        if (!(optX.isPresent() && optY.isPresent() && optZ.isPresent())) {
            this.push(sx, sy, sz);
            return new ArgsReturn<BlockPos>(String.format("%s %s %s", sx.get(), sy.get(), sz.get()));
        }
        return new ArgsReturn<BlockPos>(new BlockPos(optX.get().doubleValue(), optY.get().doubleValue(), optZ.get().doubleValue()), sx.get() + " " + sy.get() + " " + sz.get());
    }

    private Optional<Double> getPosFromString(String name, double edge) {
        if (JavaUtil.getInstance().isDouble(name)) {
            return Optional.of(Double.valueOf(name));
        }
        if (!name.startsWith("~")) {
            return Optional.empty();
        }
        if ((name = name.substring(1)).isEmpty()) {
            return Optional.of(edge);
        }
        if (JavaUtil.getInstance().isDouble(name)) {
            return Optional.of(edge + Double.valueOf(name));
        }
        return Optional.empty();
    }

    public ArgsReturn<Color> nextColor() {
        return this.parser(JavaUtil.getInstance()::getColorFromString);
    }

    public ArgsReturn<Integer> nextInteger() {
        return this.parser(i -> JavaUtil.getInstance().isInt(i) ? Optional.of(Integer.valueOf(i)) : Optional.empty());
    }

    public ArgsReturn<Item> nextItem() {
        return this.parser(ItemUtil.getInstance()::getItemFromName);
    }

    public ArgsReturn<CompoundNBT> nextNbt() {
        ArgsReturn<String> left = this.nextStringleft();
        if (left.hasArgumentError()) {
            return new ArgsReturn<CompoundNBT>();
        }
        Optional<CompoundNBT> optNbt = ItemUtil.getInstance().stringToNbt(left.get());
        if (optNbt.isPresent()) {
            return new ArgsReturn<CompoundNBT>(ItemUtil.getInstance().stringToNbt(left.get()).get(), left.getAsString());
        }
        return new ArgsReturn<CompoundNBT>(left.getAsString());
    }

    public ArgsReturn<Integer> nextKeyCode() {
        return this.parser(i -> {
            Optional<Field> optField = ReflectionUtil.getInstance().get(GLFW.class, "GLFW_KEY_" + i.toUpperCase());
            if (!optField.isPresent()) {
                return Optional.empty();
            }
            return ReflectionUtil.getInstance().get(optField.get(), null);
        });
    }

    public ArgsReturn<Module> nextModule() {
        return this.parser(Toolsmod.getInstance().getModuleManager()::getModuleByName);
    }

    @FunctionalInterface
    static interface IParser<T> {
        public Optional<T> exec(String var1);
    }
}

