/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.command;

import com.google.gson.JsonObject;
import de.whiletrue.toolsmod.command.Arguments;
import de.whiletrue.toolsmod.command.CommandError;
import de.whiletrue.toolsmod.command.defined.Command;
import de.whiletrue.toolsmod.command.defined.CommandAsSave;
import de.whiletrue.toolsmod.command.defined.CommandBind;
import de.whiletrue.toolsmod.command.defined.CommandClearChat;
import de.whiletrue.toolsmod.command.defined.CommandColor;
import de.whiletrue.toolsmod.command.defined.CommandGive;
import de.whiletrue.toolsmod.command.defined.CommandHelp;
import de.whiletrue.toolsmod.command.defined.CommandNBT;
import de.whiletrue.toolsmod.command.defined.CommandProfile;
import de.whiletrue.toolsmod.command.defined.CommandRename;
import de.whiletrue.toolsmod.command.defined.CommandSkull;
import de.whiletrue.toolsmod.command.defined.CommandToggle;
import de.whiletrue.toolsmod.command.defined.CommandYClip;
import de.whiletrue.toolsmod.util.classes.FileUtil;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class CommandManager {
    private final File saveFile;
    private List<Command> registeredCommands;

    public CommandManager(String saveFile) {
        this.saveFile = new File("toolsmod/" + saveFile);
        this.registeredCommands = Arrays.asList(new CommandToggle(), new CommandBind(), new CommandAsSave(), new CommandClearChat(), new CommandColor(), new CommandGive(), new CommandHelp(), new CommandNBT(), new CommandProfile(), new CommandRename(), new CommandSkull(), new CommandYClip());
        this.load();
    }

    public void execute(String command) {
        String[] args = command.split(" ");
        String cmd = args[0].substring(1);
        args = Arrays.copyOfRange(args, 1, args.length);
        Optional<Command> optCmd = this.registeredCommands.stream().filter(i -> i.getName().equalsIgnoreCase(cmd) || Arrays.stream(i.getShortscuts()).filter(j -> j.equalsIgnoreCase(cmd)).count() >= 1L).findAny();
        if (!optCmd.isPresent()) {
            TextUtil.getInstance().sendError("global.error.command.invalid", Character.valueOf('#'));
            return;
        }
        if (!optCmd.get().isAllowed()) {
            TextUtil.getInstance().sendError("global.error.command.forbidden", new Object[0]);
            return;
        }
        CommandError optError = optCmd.get().execute(Arguments.of(args));
        if (!optError.isFine()) {
            TextUtil.getInstance().sendError(optError.getKey(), optError.getItems());
        }
    }

    public void save() {
        JsonObject save = new JsonObject();
        for (Command cmd : this.registeredCommands) {
            save.addProperty(cmd.getName(), Boolean.valueOf(cmd.isAllowed()));
        }
        FileUtil.getInstance().printToFile(this.saveFile.getAbsolutePath(), save);
    }

    public void load() {
        try {
            JsonObject saved = FileUtil.getInstance().loadFileAsJson(this.saveFile.getAbsolutePath()).get().getAsJsonObject();
            for (Command cmd : this.registeredCommands) {
                if (!saved.has(cmd.getName())) continue;
                try {
                    cmd.setAllowed(saved.get(cmd.getName()).getAsBoolean());
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.save();
        }
    }

    public List<Command> getCommands() {
        return this.registeredCommands;
    }
}

