/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.command.defined;

import de.whiletrue.toolsmod.command.ArgsReturn;
import de.whiletrue.toolsmod.command.Arguments;
import de.whiletrue.toolsmod.command.CommandError;
import de.whiletrue.toolsmod.command.defined.Command;
import de.whiletrue.toolsmod.mod.Toolsmod;
import de.whiletrue.toolsmod.module.defined.Module;
import de.whiletrue.toolsmod.util.classes.TextUtil;

public class CommandToggle
extends Command {
    public CommandToggle() {
        super("Toggle", "t");
    }

    @Override
    public CommandError execute(Arguments args) {
        ArgsReturn<Module> optMod = args.nextModule();
        if (optMod.hasArgumentError()) {
            return CommandError.of("command.toggle.error.given.module", new Object[0]);
        }
        if (optMod.hasParseError()) {
            return CommandError.of("command.toggle.error.invalid.module", optMod.getAsString());
        }
        Module mod = optMod.get();
        if (!mod.isAllowed()) {
            return CommandError.of("command.toggle.error.allowed", mod.getName());
        }
        boolean state = mod.isActive();
        boolean notConflicting = mod.toggle();
        if (notConflicting) {
            TextUtil.getInstance().sendMessage("command.toggle.error.toggle." + (!state ? "on" : "off"), mod.getName());
            Toolsmod.getInstance().getModuleManager().save();
        }
        return CommandError.none();
    }
}

