/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.whiletrue.toolsmod.gui.GuiGroup;
import de.whiletrue.toolsmod.gui.widgets.preset.TmWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TmScreen
extends Screen {
    private List<TmWidget> widgets = new ArrayList<TmWidget>();
    private boolean dragging;
    protected TmWidget focused;

    protected TmScreen() {
        super((ITextComponent)new StringTextComponent(""));
    }

    protected TmScreen(ITextComponent titleIn) {
        super(titleIn);
    }

    public void func_231158_b_(Minecraft p_init_1_, int p_init_2_, int p_init_3_) {
        this.widgets.clear();
        super.func_231158_b_(p_init_1_, p_init_2_, p_init_3_);
    }

    protected TmScreen addWidget(TmWidget widget) {
        this.widgets.add(widget);
        widget.onInitUpdate();
        return this;
    }

    protected void removeWidget(TmWidget widget) {
        this.widgets.remove(widget);
    }

    private Optional<TmWidget> getWidgetForPos(double mX, double mY) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            TmWidget tm = this.widgets.get(i);
            if (!tm.isMouseOver(mX, mY)) continue;
            return Optional.of(tm);
        }
        return Optional.empty();
    }

    public void func_230430_a_(MatrixStack ms, int mX, int mY, float ticks) {
        this.widgets.forEach(i -> i.onRender(ms, mX, mY, ticks, this.focused));
        for (TmWidget w : this.widgets) {
            if (!w.onPostRender(ms, mX, mY)) continue;
            return;
        }
    }

    public boolean func_231044_a_(double mX, double mY, int ticks) {
        this.focused = null;
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Optional<TmWidget> w = this.widgets.get(i).onMouseClicked(mX, mY, ticks);
            if (!w.isPresent()) continue;
            this.focused = w.get();
            if (ticks == 0) {
                this.dragging = true;
            }
            return true;
        }
        return false;
    }

    public boolean func_231045_a_(double mX, double mY, int arg3, double arg4, double arg5) {
        return this.focused != null && this.dragging && arg3 == 0 ? this.focused.onMouseDragged(mX, mY, arg3, arg4, arg5) : false;
    }

    public boolean func_231048_c_(double mX, double mY, int ticks) {
        this.dragging = false;
        return this.getWidgetForPos(mX, mY).filter(i -> i.onMouseReleased(mX, mY, ticks)).isPresent();
    }

    public boolean func_231043_a_(double mX, double mY, double strength) {
        return this.getWidgetForPos(mX, mY).filter(i -> i.onMouseScrolled(mX, mY, strength)).isPresent();
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.focused != null && this.focused.onKeyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256) {
            this.func_231175_as__();
            return true;
        }
        return false;
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        return this.focused != null && this.focused.onKeyReleased(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char key, int keyCode) {
        return this.focused != null && this.focused.onCharTyped(key, keyCode);
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void onGroupGuiUpdate(GuiGroup<? extends TmScreen> group) {
    }

    public void func_231023_e_() {
        this.widgets.forEach(i -> i.onTick());
    }

    public TmWidget getFocusedWidget() {
        return this.focused;
    }

    public void unFocuse() {
        this.focused = null;
    }
}

