/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.gui.config;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.whiletrue.toolsmod.gui.widgets.TmButton;
import de.whiletrue.toolsmod.gui.widgets.preset.TmWidget;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class ConfigSwitchButton
extends TmButton {
    private float hoverSpeed = 0.1f;
    private boolean constandUnderlined = false;
    private float hoverAmount = 0.25f;
    private int backgroundColor = 0x60AA0000;
    private int lineColor = -5636096;
    private String hoverText;
    private String normalText;
    private float hoverPerc = 0.0f;
    private FontRenderer font;

    public ConfigSwitchButton(int x, int y, int width, int height, String text, TmButton.IPressable onPress) {
        super(x, y, width, height, null, onPress);
        this.font = Minecraft.func_71410_x().field_71466_p;
        this.setText(text);
    }

    @Override
    public void onRender(MatrixStack ms, int mX, int mY, float ticks, TmWidget focused) {
        int less = (int)((float)this.height * this.hoverAmount * (1.0f - this.hoverPerc));
        boolean bl = this.hovered = mX >= this.x && mY >= this.y + less && mX < this.x + this.width && mY < this.y + this.height - less;
        if (this.hovered || focused == this || this.constandUnderlined) {
            if (this.hoverPerc < 1.0f) {
                this.hoverPerc += this.hoverSpeed;
            }
        } else if (this.hoverPerc >= 0.0f) {
            this.hoverPerc -= this.hoverSpeed;
        }
        this.renderer.renderRect(ms, this.x, this.y + less, this.width, this.height - less * 2, this.backgroundColor);
        this.renderer.renderRect(ms, this.x, this.y + less, 1, this.height - less * 2, this.lineColor);
        this.renderer.renderRect(ms, this.x + this.width - 1, this.y + less, 1, this.height - less * 2, this.lineColor);
        if (this.hoverText != null && this.normalText != null) {
            String string = this.constandUnderlined || focused == this || this.hovered ? this.hoverText : this.normalText;
            int n = this.x + this.width / 2;
            int n2 = this.y + this.height / 2;
            this.font.getClass();
            this.renderer.renderCenteredString(ms, string, n, n2 - 9 / 2, -1);
        }
    }

    @Override
    public Optional<TmWidget> onMouseClicked(double mX, double mY, int ticks) {
        if (this.hovered) {
            this.onPress.execute(this);
        }
        return Optional.ofNullable(this.hovered ? this : null);
    }

    @Override
    public boolean isMouseOver(double p_isMouseOver_1_, double p_isMouseOver_3_) {
        return this.hovered;
    }

    public ConfigSwitchButton setHoverSpeed(float hoverSpeed) {
        this.hoverSpeed = hoverSpeed;
        return this;
    }

    public ConfigSwitchButton setConstandUnderlined(boolean constandUnderlined) {
        this.constandUnderlined = constandUnderlined;
        return this;
    }

    public ConfigSwitchButton setHoverAmount(float hoverAmount) {
        this.hoverAmount = hoverAmount;
        return this;
    }

    public ConfigSwitchButton setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public ConfigSwitchButton setLineColor(int lineColor) {
        this.lineColor = lineColor;
        return this;
    }

    public ConfigSwitchButton setHoverPerc(float hoverPerc) {
        this.hoverPerc = hoverPerc;
        return this;
    }

    public ConfigSwitchButton setText(String text) {
        if (text != null) {
            this.normalText = text;
            this.hoverText = "\u00a7n" + text;
        }
        return this;
    }

    public ConfigSwitchButton setTextByKey(String key, Object ... args) {
        this.setText(TextUtil.getInstance().getByKey(key, args));
        return this;
    }
}

