/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.whiletrue.toolsmod.gui.widgets.TmTextWidget;
import de.whiletrue.toolsmod.gui.widgets.preset.TmWidget;
import de.whiletrue.toolsmod.util.classes.TextUtil;

public class TmAnimatedText
extends TmTextWidget {
    private long fadeIn;
    private long fadeOut;
    private long length;
    private long start = -1L;
    private int textColor;

    public TmAnimatedText(int x, int y) {
        super(x, y, null, 0);
    }

    public TmAnimatedText setTransition(long fadeIn, long length, long fadeOut) {
        this.fadeIn = fadeIn;
        this.length = length;
        this.fadeOut = fadeOut;
        return this;
    }

    public void show(int color, String message) {
        this.setText(message);
        this.textColor = color & 0xFFFFFF;
        this.start = System.currentTimeMillis() - 100L;
    }

    public void showKey(int color, String key, Object ... args) {
        this.show(color, TextUtil.getInstance().getByKey(key, args));
    }

    @Override
    public void onRender(MatrixStack ms, int mouseX, int mouseY, float p_render_3_, TmWidget focused) {
        if (this.start == -1L) {
            return;
        }
        if (this.start + this.length + this.fadeIn + this.fadeOut - 100L <= System.currentTimeMillis()) {
            this.start = -1L;
            return;
        }
        long time = System.currentTimeMillis() - this.start;
        if (time <= this.fadeIn) {
            float perc = (float)time / (float)this.fadeIn;
            this.color = (int)(255.0f * perc) << 24 | this.textColor;
        } else if (time >= this.fadeIn + this.length) {
            float perc = 1.0f - (float)(time - this.fadeIn - this.length) / (float)this.fadeOut;
            this.color = (int)(255.0f * perc) << 24 | this.textColor;
        }
        super.onRender(ms, mouseX, mouseY, p_render_3_, focused);
    }
}

