/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.whiletrue.toolsmod.gui.widgets.preset.TmSizeWidget;
import de.whiletrue.toolsmod.gui.widgets.preset.TmWidget;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import java.util.Optional;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;

public class TmButton
extends TmSizeWidget {
    protected IPressable onPress;
    protected String display;
    protected ITextComponent tooltip;
    protected boolean enabled = true;
    private int displayColor = -1;

    public TmButton(int x, int y, int width, int height, String display, IPressable onPress) {
        super(x, y, width, height);
        this.onPress = onPress;
        this.display = display;
    }

    public TmButton setTooltipp(ITextComponent tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public TmButton setTooltippByKey(String key, Object ... args) {
        this.tooltip = TextUtil.getInstance().getITextByKey(key, args);
        return this;
    }

    public TmButton setOnPress(IPressable onPress) {
        this.onPress = onPress;
        return this;
    }

    public TmButton setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public TmButton setDisplayByKey(String key, Object ... args) {
        this.display = TextUtil.getInstance().getByKey(key, args);
        return this;
    }

    public TmButton setDisplayColor(int displayColor) {
        this.displayColor = 0xFF000000 | displayColor;
        return this;
    }

    @Override
    public Optional<TmWidget> onMouseClicked(double mX, double mY, int ticks) {
        if (this.enabled && this.hovered) {
            this.mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.onPress.execute(this);
        }
        return Optional.empty();
    }

    @Override
    public void onRender(MatrixStack ms, int mX, int mY, float ticks, TmWidget focused) {
        super.onRender(ms, mX, mY, ticks, focused);
        this.renderButton(ms, focused == this);
    }

    @Override
    public boolean onPostRender(MatrixStack ms, int mX, int mY) {
        if (this.hovered && this.enabled && this.tooltip != null) {
            this.mc.field_71462_r.func_238652_a_(ms, this.tooltip, mX, mY);
            return true;
        }
        return false;
    }

    private void renderButton(MatrixStack ms, boolean focused) {
        this.mc.func_110434_K().func_110577_a(Widget.field_230687_i_);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.enabled ? (this.hovered ? 2 : 1) : 0;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        AbstractGui.func_238464_a_((MatrixStack)ms, (int)this.x, (int)this.y, (int)0, (float)0.0f, (float)(46 + i * 20), (int)(this.width / 2), (int)this.height, (int)256, (int)256);
        AbstractGui.func_238464_a_((MatrixStack)ms, (int)(this.x + this.width / 2), (int)this.y, (int)0, (float)(200 - this.width / 2), (float)(46 + i * 20), (int)(this.width / 2), (int)this.height, (int)256, (int)256);
        int j = this.enabled ? this.displayColor : 0xA0A0A0;
        this.renderer.renderCenteredString(ms, this.getRenderText(focused), this.x + this.width / 2, this.y + (this.height - 8) / 2, j);
    }

    protected String getRenderText(boolean focused) {
        return this.display;
    }

    @FunctionalInterface
    public static interface IPressable {
        public void execute(TmButton var1);
    }
}

