/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.whiletrue.toolsmod.gui.widgets.preset.TmSizeWidget;
import de.whiletrue.toolsmod.gui.widgets.preset.TmWidget;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class TmCheckbox
extends TmSizeWidget {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/checkbox.png");
    private boolean checked;
    private Function<Boolean, Boolean> onToggle;
    private ITextComponent tooltip;

    public TmCheckbox(int x, int y, boolean isChecked, Function<Boolean, Boolean> onToggle) {
        super(x, y, 20, 20);
        this.checked = isChecked;
        this.onToggle = onToggle;
    }

    @Override
    public void move(float ... size) {
        this.x = (int)size[0];
        this.y = (int)size[1];
    }

    @Override
    public void onRender(MatrixStack ms, int mX, int mY, float ticks, TmWidget focused) {
        super.onRender(ms, mX, mY, ticks, focused);
        this.mc.func_110434_K().func_110577_a(TEXTURE);
        RenderSystem.enableDepthTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        AbstractGui.func_238463_a_((MatrixStack)ms, (int)this.x, (int)this.y, (float)0.0f, (float)(this.checked ? 20.0f : 0.0f), (int)20, (int)20, (int)64, (int)64);
    }

    @Override
    public Optional<TmWidget> onMouseClicked(double mX, double mY, int ticks) {
        if (this.hovered) {
            this.checked = this.onToggle.apply(!this.checked);
        }
        return Optional.empty();
    }

    @Override
    public boolean onPostRender(MatrixStack ms, int mX, int mY) {
        if (this.hovered && this.tooltip != null) {
            this.mc.field_71462_r.func_238652_a_(ms, this.tooltip, mX, mY);
            return true;
        }
        return false;
    }

    public TmCheckbox setTooltipp(ITextComponent tooltipp) {
        this.tooltip = tooltipp;
        return this;
    }

    public TmCheckbox setTooltippByKey(String key, Object ... args) {
        this.tooltip = TextUtil.getInstance().getITextByKey(key, args);
        return this;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }
}

