/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.whiletrue.toolsmod.gui.widgets.TmButton;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.lwjgl.opengl.GL11;

public class TmLinkButton
extends TmButton {
    private String link;
    private String hoverDisplay;
    private final double factor = 0.7;

    public TmLinkButton(int x, int y, int width, int height, String display, String link) {
        super(x, y, width, height, display, (TmButton i) -> {});
        this.link = link;
        this.setDisplay(display);
        this.setOnPress(i -> this.openUrl());
        this.setTooltipp((ITextComponent)new StringTextComponent("\u00a77" + link));
    }

    @Override
    public TmButton setDisplayByKey(String key, Object ... args) {
        return this.setDisplay(TextUtil.getInstance().getByKey(key, args));
    }

    @Override
    public boolean onPostRender(MatrixStack ms, int mX, int mY) {
        if (!this.hovered) {
            return false;
        }
        GL11.glPushMatrix();
        GL11.glScaled((double)this.factor, (double)this.factor, (double)0.0);
        GL11.glClear((int)256);
        super.onPostRender(ms, (int)((double)mX * (1.0 / this.factor)), (int)((double)mY * (1.0 / this.factor)));
        GL11.glPopMatrix();
        return true;
    }

    public TmButton setDisplay(String text) {
        this.display = text;
        this.hoverDisplay = "\u00a7n" + text;
        return this;
    }

    @Override
    protected String getRenderText(boolean focused) {
        return this.hovered ? this.hoverDisplay : this.display;
    }

    private void openUrl() {
        String url = this.link;
        if (!url.startsWith("http")) {
            url = "https://" + url;
        }
        Util.func_110647_a().func_195640_a(url);
    }
}

