/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.whiletrue.toolsmod.gui.widgets.preset.TmSizeWidget;
import de.whiletrue.toolsmod.gui.widgets.preset.TmWidget;
import java.util.Optional;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class TmSlider
extends TmSizeWidget {
    private float min;
    private float max;
    private float percCurrent;
    protected IDragable onDrag;
    protected String display = "";

    public TmSlider(int x, int y, int width, int height, float minValue, float maxValue, float currentValue, IDragable onDrag) {
        super(x, y, width, height);
        this.onDrag = onDrag;
        this.min = minValue;
        this.max = maxValue;
        this.setByValue(currentValue);
        this.setDisplay(onDrag.execute(this, currentValue));
    }

    @Override
    public void onInitUpdate() {
        this.updateDisplay();
    }

    public TmSlider setByValue(float currentValue) {
        this.percCurrent = (currentValue - this.min) / (this.max - this.min);
        return this;
    }

    public TmSlider setDragHandler(IDragable onDrag) {
        this.onDrag = onDrag;
        return this;
    }

    public float getState() {
        return this.min + (this.max - this.min) * this.percCurrent;
    }

    @Override
    public Optional<TmWidget> onMouseClicked(double mX, double mY, int ticks) {
        if (this.hovered) {
            this.onMouseDragged(mX, mY, 0, 0.0, 0.0);
        }
        return super.onMouseClicked(mX, mY, ticks);
    }

    @Override
    public boolean onMouseDragged(double mX, double mY, int arg2, double arg3, double arg4) {
        this.percCurrent = (float)(MathHelper.func_76125_a((int)((int)mX), (int)this.x, (int)(this.x + this.width)) - this.x) / (float)this.width;
        this.updateDisplay();
        return super.onMouseDragged(mX, mY, arg2, arg3, arg4);
    }

    @Override
    public void onRender(MatrixStack ms, int mX, int mY, float ticks, TmWidget focused) {
        int color;
        super.onRender(ms, mX, mY, ticks, focused);
        GuiUtils.drawContinuousTexturedBox((ResourceLocation)Widget.field_230687_i_, (int)this.x, (int)this.y, (int)0, (int)46, (int)this.width, (int)this.height, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)-90.0f);
        GuiUtils.drawContinuousTexturedBox((ResourceLocation)Widget.field_230687_i_, (int)(this.x + (int)(this.percCurrent * (float)(this.width - 8))), (int)this.y, (int)0, (int)66, (int)8, (int)this.height, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)-90.0f);
        int n = color = this.hovered ? -96 : -1;
        if (this.display != null) {
            this.renderer.renderCenteredString(ms, this.display, this.x + this.width / 2, this.y + this.height / 2 - 4, color);
        }
    }

    public void updateDisplay() {
        this.setDisplay(this.onDrag.execute(this, this.getState()));
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public static interface IDragable {
        public String execute(TmSlider var1, float var2);
    }
}

