/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.gui.widgets;

import de.whiletrue.toolsmod.gui.widgets.TmSlider;

public class TmSliderValues<Type>
extends TmSlider {
    private Type[] values;
    private Type selected = null;

    public TmSliderValues(int x, int y, int width, int height, Type[] values, int index, IValueDragable<Type> onDrag) {
        super(x, y, width, height, 0.0f, values.length - 1, index, (tm, val) -> "");
        this.values = values;
        this.setDragHandler(onDrag);
    }

    public TmSliderValues<Type> setDragHandler(IValueDragable<Type> onDrag) {
        super.setDragHandler((TmSlider tm, float val) -> {
            Type t = this.values[(int)val];
            if (t.equals(this.selected)) {
                return this.display;
            }
            this.selected = t;
            return onDrag.execute(t, (int)val);
        });
        return this;
    }

    public TmSliderValues<Type> setStateByValue(Type value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!value.equals(this.values[i])) continue;
            this.setByValue(i);
            break;
        }
        return this;
    }

    public Type getStateValue() {
        return this.selected;
    }

    @FunctionalInterface
    public static interface IValueDragable<Type> {
        public String execute(Type var1, int var2);
    }
}

