/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.gui.widgets;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.whiletrue.toolsmod.gui.widgets.preset.TmSizeWidget;
import de.whiletrue.toolsmod.gui.widgets.preset.TmWidget;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.MathHelper;

public class TmTextfield
extends TmSizeWidget {
    private String text;
    private String presetString;
    private int presetColor = 0x55AAAA;
    private int maxStringLength = 32;
    private boolean enabled = true;
    private int enabledColor = 0xE0E0E0;
    private int disabledColor = 0x707070;
    private boolean enableBackgroundDrawing = true;
    private BiFunction<String, Integer, String> textFormatter = (txt, num) -> txt;
    @Nullable
    private Consumer<String> guiResponder;
    private Predicate<String> validator = Predicates.alwaysTrue();
    private int lineScrollOffset;
    private int cursorCounter;
    private int selectionEnd;
    private int cursorPosition;
    private boolean shiftDown;

    public TmTextfield() {
        this(0, 0, 0, 0, "", null);
    }

    public TmTextfield(int x, int y, int width, int height, String text, @Nullable Consumer<String> responder) {
        super(x, y, width, height);
        this.text = text;
        this.guiResponder = responder;
    }

    public TmTextfield setValidator(Predicate<String> validator) {
        this.validator = validator;
        return this;
    }

    public TmTextfield setResponder(Consumer<String> guiResponder) {
        this.guiResponder = guiResponder;
        return this;
    }

    public TmTextfield setTextFormatter(BiFunction<String, Integer, String> textFormatter) {
        this.textFormatter = textFormatter;
        return this;
    }

    public TmTextfield setText(String text) {
        this.text = text;
        this.cursorPosition = 0;
        this.selectionEnd = 0;
        this.cursorCounter = 0;
        this.lineScrollOffset = 0;
        return this;
    }

    public TmTextfield setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
        return this;
    }

    @Override
    public void onTick() {
        ++this.cursorCounter;
    }

    @Override
    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.enabled) {
            return false;
        }
        this.shiftDown = Screen.func_231173_s_();
        if (Screen.func_231170_j_((int)keyCode)) {
            this.setCursorPosition(this.text.length());
            this.setSelectionPos(0);
            return true;
        }
        if (Screen.func_231169_i_((int)keyCode)) {
            this.mc.field_195559_v.func_197960_a(this.getSelectedText());
            return true;
        }
        if (Screen.func_231168_h_((int)keyCode)) {
            this.writeText(this.mc.field_195559_v.func_197965_a());
            return true;
        }
        switch (keyCode) {
            case 259: {
                this.shiftDown = false;
                this.delete(-1);
                this.shiftDown = Screen.func_231173_s_();
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                this.shiftDown = false;
                this.delete(1);
                this.shiftDown = Screen.func_231173_s_();
                return true;
            }
            case 262: {
                if (Screen.func_231172_r_()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 263: {
                if (Screen.func_231172_r_()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 268: {
                this.setCursorPosition(0);
                return true;
            }
            case 269: 
        }
        this.setCursorPosition(this.text.length());
        return true;
    }

    @Override
    public boolean onCharTyped(char key, int keyCode) {
        if (!this.enabled) {
            return false;
        }
        if (SharedConstants.func_71566_a((char)key)) {
            this.writeText(String.valueOf(key));
        }
        return true;
    }

    @Override
    public Optional<TmWidget> onMouseClicked(double mX, double mY, int ticks) {
        if (!this.enabled || !this.hovered) {
            return Optional.empty();
        }
        int i = MathHelper.func_76128_c((double)mX) - this.x;
        if (this.enableBackgroundDrawing) {
            i -= 4;
        }
        String trimmed = this.mc.field_71466_p.func_238412_a_(this.text.substring(this.lineScrollOffset), this.getAdjustedWidth());
        this.setCursorPosition(this.mc.field_71466_p.func_238412_a_(trimmed, i).length() + this.lineScrollOffset);
        return Optional.of(this);
    }

    @Override
    public void onRender(MatrixStack ms, int mX, int mY, float ticks, TmWidget focused) {
        String render;
        super.onRender(ms, mX, mY, ticks, focused);
        if (this.enableBackgroundDrawing) {
            AbstractGui.func_238467_a_((MatrixStack)ms, (int)(this.x - 1), (int)(this.y - 1), (int)(this.x + this.width + 1), (int)(this.y + this.height + 1), (int)-6250336);
            AbstractGui.func_238467_a_((MatrixStack)ms, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-16777216);
        }
        boolean usePreset = this.presetString != null && this.text.isEmpty();
        String string = render = usePreset ? this.presetString : this.text;
        int i = !this.enabled ? this.disabledColor : (usePreset ? this.presetColor : this.enabledColor);
        int j = this.cursorPosition - this.lineScrollOffset;
        int k = this.selectionEnd - this.lineScrollOffset;
        String s = this.mc.field_71466_p.func_238412_a_(render.substring(this.lineScrollOffset), this.getAdjustedWidth());
        boolean flag = j >= 0 && j <= s.length();
        boolean flag1 = this == focused && this.cursorCounter / 6 % 2 == 0 && flag;
        int l = this.enableBackgroundDrawing ? this.x + 4 : this.x;
        int i1 = this.enableBackgroundDrawing ? this.y + (this.height - 8) / 2 : this.y;
        int j1 = l;
        if (k > s.length()) {
            k = s.length();
        }
        if (!s.isEmpty()) {
            String s1 = flag ? s.substring(0, j) : s;
            j1 = this.mc.field_71466_p.func_238405_a_(ms, this.textFormatter.apply(s1, this.lineScrollOffset), (float)l, (float)i1, i);
        }
        boolean flag2 = this.cursorPosition < this.text.length() || this.text.length() >= this.maxStringLength;
        int k1 = j1;
        if (!flag) {
            k1 = j > 0 ? l + this.width : l;
        } else if (flag2) {
            k1 = j1 - 1;
            --j1;
        }
        if (!s.isEmpty() && flag && j < s.length()) {
            this.mc.field_71466_p.func_238405_a_(ms, this.textFormatter.apply(s.substring(j), this.cursorPosition), (float)j1, (float)i1, i);
        }
        if (flag1) {
            if (flag2) {
                AbstractGui.func_238467_a_((MatrixStack)ms, (int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + 9), (int)-3092272);
            } else {
                this.mc.field_71466_p.func_238405_a_(ms, "_", (float)k1, (float)i1, i);
            }
        }
        if (k != j) {
            int l1 = l + this.mc.field_71466_p.func_78256_a(s.substring(0, k));
            this.drawSelectionBox(k1, i1 - 1, l1 - 1, i1 + 1 + 9);
        }
    }

    public void setCursorPosition(int pos) {
        this.clampCursorPosition(pos);
        if (!this.shiftDown) {
            this.setSelectionPos(this.cursorPosition);
        }
        this.onTextChanged(this.text);
    }

    public void clampCursorPosition(int pos) {
        this.cursorPosition = MathHelper.func_76125_a((int)pos, (int)0, (int)this.text.length());
    }

    private void onTextChanged(String newText) {
        if (this.guiResponder != null) {
            this.guiResponder.accept(newText);
        }
    }

    private void delete(int p_212950_1_) {
        if (Screen.func_231172_r_()) {
            this.deleteWords(p_212950_1_);
        } else {
            this.deleteFromCursor(p_212950_1_);
        }
    }

    public void deleteWords(int num) {
        if (this.text.isEmpty()) {
            return;
        }
        if (this.selectionEnd != this.cursorPosition) {
            this.writeText("");
        } else {
            this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
        }
    }

    public void deleteFromCursor(int num) {
        if (this.text.isEmpty()) {
            return;
        }
        if (this.selectionEnd != this.cursorPosition) {
            this.writeText("");
        } else {
            boolean flag = num < 0;
            int i = flag ? this.cursorPosition + num : this.cursorPosition;
            int j = flag ? this.cursorPosition : this.cursorPosition + num;
            String s = "";
            if (i >= 0) {
                s = this.text.substring(0, i);
            }
            if (j < this.text.length()) {
                s = s + this.text.substring(j);
            }
            if (this.validator.test(s)) {
                this.text = s;
                if (flag) {
                    this.moveCursorBy(num);
                }
                this.onTextChanged(this.text);
            }
        }
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.cursorPosition);
    }

    private int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    private int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.cursorPosition + num);
    }

    public void setSelectionPos(int position) {
        int i = this.text.length();
        this.selectionEnd = MathHelper.func_76125_a((int)position, (int)0, (int)i);
        if (this.mc.field_71466_p != null) {
            if (this.lineScrollOffset > i) {
                this.lineScrollOffset = i;
            }
            int j = this.getAdjustedWidth();
            String s = this.mc.field_71466_p.func_238412_a_(this.text.substring(this.lineScrollOffset), j);
            int k = s.length() + this.lineScrollOffset;
            if (this.selectionEnd == this.lineScrollOffset) {
                this.lineScrollOffset -= this.mc.field_71466_p.func_238413_a_(this.text, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.lineScrollOffset += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - this.selectionEnd;
            }
            this.lineScrollOffset = MathHelper.func_76125_a((int)this.lineScrollOffset, (int)0, (int)i);
        }
    }

    public int getAdjustedWidth() {
        return this.enableBackgroundDrawing ? this.width - 8 : this.width;
    }

    public String getSelectedText() {
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        return this.text.substring(i, j);
    }

    public String getText() {
        return this.text;
    }

    public void writeText(String textToWrite) {
        int l;
        String s = "";
        String s1 = SharedConstants.func_71565_a((String)textToWrite);
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int k = this.maxStringLength - this.text.length() - (i - j);
        if (!this.text.isEmpty()) {
            s = s + this.text.substring(0, i);
        }
        if (k < s1.length()) {
            s = s + s1.substring(0, k);
            l = k;
        } else {
            s = s + s1;
            l = s1.length();
        }
        if (!this.text.isEmpty() && j < this.text.length()) {
            s = s + this.text.substring(j);
        }
        if (!this.validator.test(s)) {
            return;
        }
        this.text = s;
        this.clampCursorPosition(i + l);
        this.setSelectionPos(this.cursorPosition);
        this.onTextChanged(this.text);
    }

    private void drawSelectionBox(int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.x + this.width) {
            endX = this.x + this.width;
        }
        if (startX > this.x + this.width) {
            startX = this.x + this.width;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_225582_a_((double)startX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_((double)endX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_((double)endX, (double)startY, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_((double)startX, (double)startY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    public TmTextfield setPresetStringByKey(String key, Object ... args) {
        this.presetString = TextUtil.getInstance().getByKey(key, args);
        return this;
    }

    public TmTextfield setPresetColor(int presetColor) {
        this.presetColor = presetColor;
        return this;
    }

    public TmTextfield setPresetString(String presetString) {
        this.presetString = presetString;
        return this;
    }
}

