/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.gui.widgets.rounding.listscaleable;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.whiletrue.toolsmod.gui.widgets.preset.TmSizeWidget;
import de.whiletrue.toolsmod.gui.widgets.preset.TmWidget;
import de.whiletrue.toolsmod.gui.widgets.rounding.EnumListSlider;
import de.whiletrue.toolsmod.gui.widgets.rounding.listscaleable.ScaleableListItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.math.MathHelper;

public class ScaleableListView<ItemView extends ScaleableListItem<?>>
extends TmSizeWidget {
    private int scrolled;
    private float scrollStrength = 1.0f;
    private EnumListSlider slider = EnumListSlider.RIGHT;
    private final int sliderWidth = 6;
    private int sliderDragOffset;
    private int sliderHeight;
    private int spaceY;
    private List<ItemView> views = new ArrayList<ItemView>();
    private List<ItemView> visibleViews = new ArrayList<ItemView>();
    private int listHeight;
    private int background = -1;
    private Function<ItemView, Boolean> validator = null;

    public ScaleableListView(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setSpaceY(5);
    }

    @Override
    public void onRender(MatrixStack ms, int mX, int mY, float ticks, TmWidget focused) {
        super.onRender(ms, mX, mY, ticks, focused);
        if (!this.hovered) {
            mX = this.x - 5;
            mY = this.y - 5;
        }
        if (this.background != -1) {
            AbstractGui.func_238467_a_((MatrixStack)ms, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)this.background);
        }
        this.renderer.startScissor(this.x, this.y, this.width, this.height);
        for (ScaleableListItem iv : this.visibleViews) {
            if (iv.y > this.y + this.height) break;
            if (iv.y + iv.getHeight() < this.y) continue;
            iv.render(ms, mX, mY, ticks, focused);
        }
        this.renderer.stopScissor();
        if (this.listHeight > this.height && !this.slider.equals((Object)EnumListSlider.NONE)) {
            int sX = this.x + (this.slider.equals((Object)EnumListSlider.LEFT) ? -this.sliderWidth : this.width);
            int sY = this.getSliderY();
            this.renderer.renderRect(ms, sX, this.y, this.sliderWidth, this.height, -16777216);
            this.renderer.renderRect(ms, sX, sY, this.sliderWidth, this.sliderHeight, -8355712);
            this.renderer.renderRect(ms, sX, sY, this.sliderWidth - 1, this.sliderHeight - 1, -4144960);
        }
    }

    @Override
    public boolean onPostRender(MatrixStack ms, int mX, int mY) {
        if (!this.hovered) {
            return false;
        }
        for (ScaleableListItem iv : this.visibleViews) {
            if (iv.y > this.y + this.height) break;
            if (iv.y + iv.getHeight() < this.y || !iv.onPostRender(ms, mX, mY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Optional<TmWidget> onMouseClicked(double mX, double mY, int ticks) {
        if (this.listHeight > this.height && !this.slider.equals((Object)EnumListSlider.NONE)) {
            int sliderY = this.getSliderY();
            int sliderX = this.x + (this.slider.equals((Object)EnumListSlider.LEFT) ? -this.sliderWidth : this.width);
            if (mX >= (double)sliderX && mX <= (double)(sliderX + this.sliderWidth) && mY >= (double)sliderY && mY <= (double)(sliderY + this.sliderHeight)) {
                this.sliderDragOffset = (int)(mY - (double)sliderY);
                return Optional.of(this);
            }
        }
        if (!this.hovered) {
            return Optional.empty();
        }
        for (ScaleableListItem iv : this.visibleViews) {
            TmWidget wid;
            if (iv.y > this.y + this.height) break;
            if (iv.y + iv.getHeight() < this.y || (wid = iv.onMouseClicked(mX, mY, ticks)) == null) continue;
            return Optional.of(wid);
        }
        return Optional.empty();
    }

    @Override
    public boolean onMouseDragged(double mX, double mY, int arg2, double arg3, double arg4) {
        double perc = MathHelper.func_151237_a((double)((mY - (double)this.sliderDragOffset - (double)this.y) / (double)(this.height - this.sliderHeight)), (double)0.0, (double)1.0);
        this.updateScroll((int)((double)(this.listHeight - this.height) * perc));
        this.updateItems();
        return true;
    }

    @Override
    public boolean onMouseScrolled(double mX, double mY, double strength) {
        this.updateScroll((int)((double)this.scrolled - strength * (double)this.scrollStrength));
        this.updateItems();
        return true;
    }

    @Override
    public void onTick() {
        this.views.forEach(i -> i.onTick());
    }

    @Override
    public void move(float ... size) {
        super.move(size);
        this.views.forEach(i -> {
            int h = i.handleChangePosition(this.x, this.width);
            if (h > 0) {
                i.setHeight(h);
            }
        });
        this.calculateListHeight();
        this.updateScroll(this.scrolled);
        this.updateItems();
    }

    public void handleHeightChange() {
        this.calculateListHeight();
        this.updateScroll(this.scrolled);
        this.updateItems();
    }

    public ScaleableListView<ItemView> setSpaceY(int spaceY) {
        this.spaceY = spaceY;
        return this;
    }

    public ScaleableListView<ItemView> setItems(ItemView ... items) {
        this.views.clear();
        this.views.addAll(Arrays.asList(items));
        this.views.forEach(i -> i.handlePostInit(this::handleHeightChange, this.x, this.width));
        this.updateValidation();
        return this;
    }

    public ScaleableListView<ItemView> setScrollStrength(float scrollStrength) {
        this.scrollStrength = scrollStrength;
        return this;
    }

    public ScaleableListView<ItemView> setBackground(int background) {
        this.background = background;
        return this;
    }

    public ScaleableListView<ItemView> setValidator(Function<ItemView, Boolean> validator) {
        this.validator = validator;
        return this;
    }

    private void calculateListHeight() {
        int hV = this.visibleViews.size() > 0 ? this.visibleViews.stream().map(i -> i.getHeight()).reduce((a, b) -> a + b).get() : 0;
        this.listHeight = this.spaceY * (this.visibleViews.size() - 1) + hV;
    }

    public void updateItems() {
        int usedHeight = 0;
        for (int i = 0; i < this.visibleViews.size(); ++i) {
            ScaleableListItem iv = (ScaleableListItem)this.visibleViews.get(i);
            int y = this.y + usedHeight + this.spaceY * i - this.scrolled;
            usedHeight += iv.getHeight();
            iv.handleChangePositionScrolled(y);
        }
    }

    public void updateScroll(int newScroll) {
        this.scrolled = this.listHeight > this.height ? MathHelper.func_76125_a((int)newScroll, (int)0, (int)(this.listHeight - this.height)) : 0;
        this.sliderHeight = Math.max(20, (int)((float)this.height * ((float)this.height / (float)this.listHeight)));
    }

    public void updateValidation() {
        this.visibleViews.clear();
        if (this.validator == null) {
            this.visibleViews.addAll(this.views);
        } else {
            this.visibleViews.addAll(this.views.stream().filter(this.validator::apply).collect(Collectors.toList()));
        }
        this.calculateListHeight();
        this.updateScroll(this.scrolled);
        this.updateItems();
    }

    private int getSliderY() {
        return (int)((float)this.y + (float)(this.height - this.sliderHeight) * ((float)this.scrolled / (float)(this.listHeight - this.height)));
    }

    public List<ItemView> getViews() {
        return this.views;
    }

    public int getScrolled() {
        return this.scrolled;
    }
}

