/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.module;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import de.whiletrue.toolsmod.module.ModuleCategory;
import de.whiletrue.toolsmod.module.defined.Module;
import de.whiletrue.toolsmod.module.defined.tools.ModuleAsEdit;
import de.whiletrue.toolsmod.module.defined.tools.ModuleBannerWriter;
import de.whiletrue.toolsmod.module.defined.tools.ModuleGhostsight;
import de.whiletrue.toolsmod.module.defined.tools.ModuleHeadWriter;
import de.whiletrue.toolsmod.module.defined.tools.ModuleMapcreator;
import de.whiletrue.toolsmod.module.defined.tools.ModuleTeleport;
import de.whiletrue.toolsmod.module.defined.tools.ModuleTimer;
import de.whiletrue.toolsmod.module.defined.utils.ModuleAutoFish;
import de.whiletrue.toolsmod.module.defined.utils.ModuleAutoWalk;
import de.whiletrue.toolsmod.module.defined.utils.ModuleEntityFly;
import de.whiletrue.toolsmod.module.defined.utils.ModuleFastbreak;
import de.whiletrue.toolsmod.module.defined.utils.ModuleFastplace;
import de.whiletrue.toolsmod.module.defined.utils.ModuleInvMove;
import de.whiletrue.toolsmod.module.defined.utils.ModuleNoFall;
import de.whiletrue.toolsmod.module.defined.utils.ModuleSprint;
import de.whiletrue.toolsmod.module.defined.utils.ModuleStep;
import de.whiletrue.toolsmod.module.defined.utils.ModuleVelocity;
import de.whiletrue.toolsmod.module.defined.visual.ModuleFullbright;
import de.whiletrue.toolsmod.module.defined.visual.ModuleShulkerView;
import de.whiletrue.toolsmod.settings.Setting;
import de.whiletrue.toolsmod.util.classes.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;

public class ModuleManager {
    private final File saveFile;
    private List<Module> registeredModules;
    private List<Module> enabledModules = new ArrayList<Module>();
    private List<Module> disabledModules = new ArrayList<Module>();
    private String[][] moduleStats;

    public ModuleManager(String saveFile) {
        this.saveFile = new File("toolsmod/" + saveFile);
        this.registeredModules = Arrays.asList(new ModuleAutoWalk(), new ModuleEntityFly(), new ModuleInvMove(), new ModuleSprint(), new ModuleStep(), new ModuleTeleport(), new ModuleVelocity(), new ModuleAutoFish(), new ModuleGhostsight(), new ModuleNoFall(), new ModuleTimer(), new ModuleAsEdit(), new ModuleBannerWriter(), new ModuleHeadWriter(), new ModuleMapcreator(), new ModuleFullbright(), new ModuleShulkerView(), new ModuleFastbreak(), new ModuleFastplace());
        this.registeredModules.forEach(i -> i.init());
        this.disabledModules.addAll(this.registeredModules);
    }

    public void save() {
        JsonObject save = new JsonObject();
        for (Module mod : this.getModules()) {
            JsonObject modSave = new JsonObject();
            modSave.addProperty("key", (Number)mod.getKeyBind());
            modSave.addProperty("enabled", Boolean.valueOf(mod.isActive()));
            modSave.addProperty("allowed", Boolean.valueOf(mod.isAllowed()));
            JsonObject settings = new JsonObject();
            for (Setting<?> set : mod.getSettings()) {
                settings.addProperty(set.getName(), set.handleSave());
            }
            modSave.add("settings", (JsonElement)settings);
            save.add(mod.getName(), (JsonElement)modSave);
        }
        FileUtil.getInstance().printToFile(this.saveFile.getAbsolutePath(), save);
    }

    public void load() {
        try {
            JsonObject saved = FileUtil.getInstance().loadFileAsJson(this.saveFile.getAbsolutePath()).get().getAsJsonObject();
            for (Module mod : this.getModules()) {
                if (!saved.has(mod.getName())) continue;
                JsonObject data = saved.get(mod.getName()).getAsJsonObject();
                mod.setAllowed(data.get("allowed").getAsBoolean());
                if (mod.isAllowed() && mod.isAvaiableAtStart() && data.get("enabled").getAsBoolean()) {
                    mod.enable();
                }
                mod.setKeyBind(data.get("key").getAsInt());
                if (!data.has("settings")) continue;
                JsonObject settings = data.get("settings").getAsJsonObject();
                for (Setting<?> set : mod.getSettings()) {
                    if (!settings.has(set.getName())) continue;
                    set.handleParse(settings.get(set.getName()).getAsString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.save();
        }
    }

    public void executeEvent(Consumer<Module> event) {
        new ArrayList<Module>(this.getEnabledModules()).forEach(event::accept);
    }

    public void handleModUpdate(Module mod) {
        if (mod.isActive()) {
            this.disabledModules.remove(mod);
            this.enabledModules.add(mod);
        } else {
            this.disabledModules.add(mod);
            this.enabledModules.remove(mod);
        }
        this.save();
        this.updateInfoDisplay();
    }

    public void handleRender(MatrixStack ms) {
        int counter = 0;
        if (this.moduleStats != null) {
            String[][] stringArray = this.moduleStats;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] info;
                for (String text : info = stringArray[i]) {
                    Minecraft.func_71410_x().field_71466_p.func_238405_a_(ms, text, 10.0f, (float)(counter += 10), -1);
                }
                counter += 5;
            }
        }
    }

    public List<Module> getModulesByCategory(ModuleCategory category) {
        return this.getModules().stream().filter(i -> i.getCategory().equals((Object)category)).collect(Collectors.toList());
    }

    public <T extends Module> Optional<T> getModuleByClass(Class<T> clazz) {
        return this.registeredModules.stream().filter(i -> i.getClass().equals(clazz)).map(i -> i).findAny();
    }

    public Optional<Module> getModuleByName(String name) {
        return this.registeredModules.stream().filter(i -> i.getName().equalsIgnoreCase(name)).findAny();
    }

    public void updateInfoDisplay() {
        this.moduleStats = (String[][])this.enabledModules.stream().map(i -> {
            String[] data = (String[])Arrays.stream(i.onInformationEvent('b', '6')).filter(x -> x != null).toArray(String[]::new);
            if (data.length <= 0) {
                return null;
            }
            String[] all = new String[data.length + 1];
            all[0] = "\u00a7c" + i.getName();
            System.arraycopy(data, 0, all, 1, data.length);
            return all;
        }).filter(i -> i != null).toArray(x$0 -> new String[x$0][]);
    }

    public List<Module> getDisabledModules() {
        return this.disabledModules;
    }

    public List<Module> getEnabledModules() {
        return this.enabledModules;
    }

    public List<Module> getModules() {
        return this.registeredModules;
    }
}

