/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.module.defined;

import de.whiletrue.toolsmod.gui.GuiGroup;
import de.whiletrue.toolsmod.gui.TmScreen;
import de.whiletrue.toolsmod.gui.config.sub.modules.GuiDefaultSettings;
import de.whiletrue.toolsmod.gui.quickaccess.GuiQuickAccess;
import de.whiletrue.toolsmod.mod.Toolsmod;
import de.whiletrue.toolsmod.module.ModuleCategory;
import de.whiletrue.toolsmod.settings.Setting;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;

public abstract class Module {
    private boolean allowed = true;
    private final String name;
    private final ModuleCategory category;
    private int keyBind = -1;
    private boolean active;
    private boolean avaiableAtStart;
    private Set<Setting<?>> settings;
    protected Minecraft mc = Minecraft.func_71410_x();
    @Nullable
    private GuiGroup<GuiQuickAccess> quickAccessGui;

    public Module(String name, ModuleCategory category, boolean avaiableAtStart) {
        this.name = name;
        this.category = category;
        this.keyBind = -1;
        this.avaiableAtStart = avaiableAtStart;
    }

    public void init() {
        this.settings = Arrays.stream(this.getClass().getDeclaredFields()).filter(i -> Setting.class.isAssignableFrom(i.getType())).map(i -> {
            try {
                i.setAccessible(true);
                return (Setting)i.get(this);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.toSet());
        if (!this.settings.isEmpty()) {
            this.quickAccessGui = GuiGroup.of((TmScreen[])new GuiQuickAccess[]{new GuiDefaultSettings(this)});
        }
    }

    public void onEnable() {
    }

    public void onDisable() {
    }

    public void onDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
    }

    public void onKeyToggled(InputEvent.KeyInputEvent event) {
    }

    public void onPlace(BlockEvent.EntityPlaceEvent event) {
    }

    public void onTick(TickEvent.ClientTickEvent event) {
    }

    public boolean onServerPacket(IPacket<IClientPlayNetHandler> packet) {
        return true;
    }

    public boolean onClientPacket(IPacket<IServerPlayNetHandler> packet) {
        return true;
    }

    public void onRender2D(boolean tablist, RenderGameOverlayEvent.Pre event) {
    }

    public void onRender3D(RenderWorldLastEvent event) {
    }

    public void onScrollMouse(InputEvent.MouseScrollEvent event) {
    }

    public void onWorldLoad(WorldEvent.Load evt) {
    }

    public String[] onInformationEvent(char main, char sec) {
        return new String[0];
    }

    public final Optional<Module[]> enable() {
        if (this.active) {
            return Optional.empty();
        }
        this.active = true;
        this.onEnable();
        Toolsmod.getInstance().getModuleManager().handleModUpdate(this);
        return Optional.empty();
    }

    public final void disable() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.onDisable();
        Toolsmod.getInstance().getModuleManager().handleModUpdate(this);
    }

    public final boolean toggle() {
        if (this.active) {
            this.disable();
            return true;
        }
        Optional<Module[]> optConf = this.enable();
        if (optConf.isPresent()) {
            Module[] conflicting = optConf.get();
            String formatted = Arrays.stream(conflicting).map(i -> i.getName()).collect(Collectors.joining(", "));
            TextUtil.getInstance().sendError("global.module.toggle.error.incompatible." + (conflicting.length > 1 ? "multi" : "one"), formatted, this.getName());
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return TextUtil.getInstance().getByKey("module." + this.getName().toLowerCase() + ".description");
    }

    public ModuleCategory getCategory() {
        return this.category;
    }

    public int getKeyBind() {
        return this.keyBind;
    }

    public void setKeyBind(int keyBind) {
        this.keyBind = keyBind;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isAvaiableAtStart() {
        return this.avaiableAtStart;
    }

    public GuiGroup<GuiQuickAccess> getQuickAccessGui() {
        return this.quickAccessGui;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public void setAllowed(boolean allowed) {
        this.allowed = allowed;
    }

    public Set<Setting<?>> getSettings() {
        return this.settings;
    }
}

