/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.module.defined.tools;

import com.google.gson.JsonElement;
import de.whiletrue.toolsmod.gui.GuiGroup;
import de.whiletrue.toolsmod.gui.TmScreen;
import de.whiletrue.toolsmod.gui.quickaccess.GuiQuickAccess;
import de.whiletrue.toolsmod.mod.Toolsmod;
import de.whiletrue.toolsmod.module.ModuleCategory;
import de.whiletrue.toolsmod.module.defined.Module;
import de.whiletrue.toolsmod.module.defined.tools.headwriter.Alphabet;
import de.whiletrue.toolsmod.module.defined.tools.headwriter.gui.GuiQaHeadWriterText;
import de.whiletrue.toolsmod.module.defined.tools.headwriter.gui.GuiQaHeadWriterType;
import de.whiletrue.toolsmod.util.classes.FileUtil;
import de.whiletrue.toolsmod.util.classes.ItemUtil;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.world.BlockEvent;

public class ModuleHeadWriter
extends Module {
    private static final ResourceLocation LOCATION_HEADS = new ResourceLocation("toolsmod", "module/headwriter/heads.json");
    private static final GuiGroup<GuiQuickAccess> ENABLE_GUI = GuiGroup.of((TmScreen[])new GuiQuickAccess[]{new GuiQaHeadWriterText(), new GuiQaHeadWriterType()});
    public List<Alphabet> loadedAlphabets = new ArrayList<Alphabet>();
    public Alphabet selected;
    private List<ItemStack> remaningHeads = new ArrayList<ItemStack>();
    private String usedAlphabet;
    private String text;
    private boolean enabled;

    public ModuleHeadWriter() {
        super("HeadWriter", ModuleCategory.TOOLS, false);
        this.loadedAlphabets = FileUtil.getInstance().loadFromRSCAsJson(LOCATION_HEADS).get().getAsJsonObject().entrySet().stream().map(i -> new Alphabet((String)i.getKey(), ((JsonElement)i.getValue()).getAsJsonObject())).collect(Collectors.toList());
        this.selected = this.loadedAlphabets.get(0);
    }

    @Override
    public void onEnable() {
        if (!this.enabled) {
            this.disable();
            ENABLE_GUI.open();
            return;
        }
        this.enabled = false;
        this.giveNextHead();
    }

    @Override
    public void onPlace(BlockEvent.EntityPlaceEvent event) {
        if (!this.mc.field_71439_g.func_184614_ca().func_77973_b().equals(Items.field_196184_dx)) {
            return;
        }
        if (!Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
            TextUtil.getInstance().sendError("modules.headwriter.error.gm", new Object[0]);
            this.disable();
            return;
        }
        this.giveNextHead();
    }

    @Override
    public void onDisable() {
        this.enabled = false;
    }

    @Override
    public String[] onInformationEvent(char main, char sec) {
        return new String[]{String.format("\u00a7%cText: \u00a7%c%s", Character.valueOf(main), Character.valueOf(sec), this.text), String.format("\u00a7%cAlphabet: \u00a7%c%s", Character.valueOf(main), Character.valueOf(sec), this.usedAlphabet), String.format("\u00a7%cRemaining: \u00a7%c%d", Character.valueOf(main), Character.valueOf(sec), this.remaningHeads.size() + 1)};
    }

    private void giveNextHead() {
        if (this.remaningHeads.isEmpty()) {
            this.disable();
            ItemUtil.getInstance().setItem(ItemStack.field_190927_a);
            return;
        }
        ItemUtil.getInstance().setItem(this.remaningHeads.get(0));
        this.remaningHeads.remove(0);
        Toolsmod.getInstance().getModuleManager().updateInfoDisplay();
    }

    public void startWriting(String text) {
        this.disable();
        if (this.loadedAlphabets == null || this.loadedAlphabets.isEmpty()) {
            TextUtil.getInstance().sendError("modules.headwriter.error.unload", new Object[0]);
            return;
        }
        if (!Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
            TextUtil.getInstance().sendError("modules.headwriter.error.gm", new Object[0]);
            return;
        }
        this.remaningHeads.clear();
        for (char c : text.toCharArray()) {
            final String id = this.selected.getIDFromChar(c);
            CompoundNBT b64 = new CompoundNBT(){
                {
                    CompoundNBT textures = new CompoundNBT(){
                        {
                            CompoundNBT skin = new CompoundNBT(){
                                {
                                    this.func_74778_a("url", "http://textures.minecraft.net/texture/" + id);
                                }
                            };
                            this.func_218657_a("SKIN", (INBT)skin);
                        }
                    };
                    this.func_218657_a("textures", (INBT)textures);
                }
            };
            final String headB64 = Base64.getEncoder().encodeToString(b64.toString().getBytes());
            CompoundNBT nbt = new CompoundNBT(){
                {
                    CompoundNBT skullOwner = new CompoundNBT(){
                        {
                            this.func_186854_a("Id", UUID.randomUUID());
                            CompoundNBT properties = new CompoundNBT(){
                                {
                                    ListNBT textures = new ListNBT(){
                                        {
                                            CompoundNBT val = new CompoundNBT(){
                                                {
                                                    this.func_74778_a("Value", headB64);
                                                }
                                            };
                                            this.add(val);
                                        }
                                    };
                                    this.func_218657_a("textures", (INBT)textures);
                                }
                            };
                            this.func_218657_a("Properties", (INBT)properties);
                        }
                    };
                    this.func_218657_a("SkullOwner", (INBT)skullOwner);
                }
            };
            char p = '\u00a7';
            ItemStack head = new ItemStack((IItemProvider)Items.field_196184_dx);
            head.func_77982_d(nbt);
            head.func_200302_a((ITextComponent)new StringTextComponent(String.format("%c8[%c%c" + this.getName() + "%c8]: %c%c%s", Character.valueOf(p), Character.valueOf(p), Character.valueOf('b'), Character.valueOf(p), Character.valueOf(p), Character.valueOf('6'), text)));
            this.remaningHeads.add(head);
        }
        this.text = text;
        this.usedAlphabet = this.selected.getName();
        this.mc.func_147108_a(null);
        this.enabled = true;
        this.enable();
    }
}

