/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.module.defined.tools;

import de.whiletrue.toolsmod.gui.GuiGroup;
import de.whiletrue.toolsmod.gui.TmScreen;
import de.whiletrue.toolsmod.gui.quickaccess.GuiQuickAccess;
import de.whiletrue.toolsmod.module.ModuleCategory;
import de.whiletrue.toolsmod.module.defined.Module;
import de.whiletrue.toolsmod.module.defined.tools.mapcreator.BlockSelection;
import de.whiletrue.toolsmod.module.defined.tools.mapcreator.EnumRenderSettings;
import de.whiletrue.toolsmod.module.defined.tools.mapcreator.gui.GuiQaMapcreatorColor;
import de.whiletrue.toolsmod.module.defined.tools.mapcreator.gui.GuiQaMapcreatorCreate;
import de.whiletrue.toolsmod.module.defined.tools.mapcreator.gui.GuiQaMapcreatorImage;
import de.whiletrue.toolsmod.module.defined.tools.mapcreator.gui.GuiQaMapcreatorPosition;
import de.whiletrue.toolsmod.module.defined.tools.mapcreator.gui.GuiQaMapcreatorRender;
import de.whiletrue.toolsmod.settings.Setting;
import de.whiletrue.toolsmod.settings.defined.SettingKeybind;
import de.whiletrue.toolsmod.util.ColorConverter;
import de.whiletrue.toolsmod.util.Keybind;
import de.whiletrue.toolsmod.util.Timer;
import de.whiletrue.toolsmod.util.classes.ImageUtil;
import de.whiletrue.toolsmod.util.classes.JavaUtil;
import de.whiletrue.toolsmod.util.classes.RenderUtil;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.dispenser.IPosition;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CChatMessagePacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.event.TickEvent;
import org.lwjgl.opengl.GL11;

public class ModuleMapcreator
extends Module {
    public SettingKeybind sGuiBind = (SettingKeybind)((Setting)new SettingKeybind().name("guiKeybind")).standard((Keybind)new Keybind(70, KeyModifier.NONE));
    private BufferedImage loaded;
    private BufferedImage scaled;
    private int scale = 4;
    private BlockPos pos;
    private EnumRenderSettings rendering = EnumRenderSettings.CORNERS;
    private ColorConverter converter;
    private Map<Color, BlockSelection> blockPalete = new HashMap<Color, BlockSelection>();
    private List<String> loadCommands = new ArrayList<String>();
    private Timer timer = new Timer();
    private int delay;
    private GuiGroup<GuiQuickAccess> guis = GuiGroup.of((TmScreen[])new GuiQuickAccess[]{new GuiQaMapcreatorImage(), new GuiQaMapcreatorRender(), new GuiQaMapcreatorPosition(), new GuiQaMapcreatorColor(), new GuiQaMapcreatorCreate()});
    private static final Block[] INVALID_BLOCK = new Block[]{Blocks.field_150350_a, Blocks.field_150332_K};

    public ModuleMapcreator() {
        super("Mapcreator", ModuleCategory.TOOLS, false);
        this.blockPalete = new HashMap<Color, BlockSelection>();
        Registry.field_212618_g.forEach(i -> {
            if (Arrays.stream(INVALID_BLOCK).filter(x -> i == x).count() > 0L) {
                return;
            }
            MaterialColor c = i.func_235697_s_();
            if (c.field_76291_p == 31744 || c.field_76291_p == 0) {
                return;
            }
            Color asC = new Color(c.field_76291_p);
            if (this.blockPalete.containsKey(asC)) {
                this.blockPalete.get(asC).getAvailableBlocks().add((Block)i);
            } else {
                this.blockPalete.put(asC, new BlockSelection(asC, (Block)i));
            }
        });
        this.converter = new ColorConverter(this.blockPalete.keySet().toArray(new Color[this.blockPalete.keySet().size()]));
    }

    @Override
    public void onEnable() {
        this.loadCommands.clear();
    }

    @Override
    public void onRender3D(RenderWorldLastEvent event) {
        if (this.scaled == null || this.pos == null || !this.pos.func_218137_a((IPosition)this.mc.field_71439_g.func_213303_ch(), 200.0)) {
            return;
        }
        GL11.glPushMatrix();
        switch (this.rendering) {
            case ALL: {
                this.renderAll();
                break;
            }
            case CORNERS: {
                this.renderCorners();
                break;
            }
            case NEAR_ME: {
                this.renderNearMe();
                break;
            }
        }
        GL11.glPopMatrix();
    }

    @Override
    public void onKeyToggled(InputEvent.KeyInputEvent event) {
        if (((Keybind)this.sGuiBind.value).isKeycodeMatching(event.getKey())) {
            this.guis.open();
        }
    }

    @Override
    public void onTick(TickEvent.ClientTickEvent event) {
        if (this.loadCommands.isEmpty() || !this.timer.hasReached(this.delay)) {
            return;
        }
        do {
            this.timer.reset();
            String cmd = "/setblock " + this.loadCommands.get(0);
            this.loadCommands.remove(0);
            this.mc.field_71439_g.field_71174_a.func_147297_a((IPacket)new CChatMessagePacket(cmd));
            if (!this.loadCommands.isEmpty()) continue;
            TextUtil.getInstance().sendMessage("modules.mapcreator.finish", new Object[0]);
        } while (this.delay == 0 && !this.loadCommands.isEmpty());
    }

    public String create(float delay) {
        this.delay = (int)(delay * 1000.0f);
        this.loadCommands.clear();
        if (this.scaled == null || this.pos == null) {
            return TextUtil.getInstance().getByKey("modules.mapcreator.start.failed");
        }
        this.mc.func_147108_a(null);
        for (int x = 0; x < this.scaled.getWidth(); ++x) {
            for (int y = 0; y < this.scaled.getHeight(); ++y) {
                if (this.scaled.getRGB(x, y) >> 24 == 0) continue;
                Color color = new Color(this.scaled.getRGB(x, y));
                Color nearest = this.converter.nearestColor(color);
                Block b = this.blockPalete.get(nearest).getSelected();
                BlockPos set = this.pos.func_177982_a(x, 0, y);
                if (this.mc.field_71441_e.func_180495_p(set).func_177230_c().equals(b)) continue;
                this.loadCommands.add(String.format("%d %d %d minecraft:%s", set.func_177958_n(), set.func_177956_o(), set.func_177952_p(), b.func_149739_a().substring("block.minecraft.".length())));
            }
        }
        return TextUtil.getInstance().getByKey("modules.mapcreator.start");
    }

    private void renderAll() {
        for (int x = 0; x < this.scaled.getWidth(); ++x) {
            for (int y = 0; y < this.scaled.getHeight(); ++y) {
                Color color = new Color(this.scaled.getRGB(x, y));
                GL11.glColor3f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
                RenderUtil.getInstance().renderBlockOverlay(this.pos.func_177958_n() + x, this.pos.func_177956_o(), this.pos.func_177952_p() + y, 0.7f);
            }
        }
    }

    private void renderNearMe() {
        BlockPos pos = this.mc.field_71439_g.func_233580_cy_();
        for (int x = 0; x < this.scaled.getWidth(); ++x) {
            for (int y = 0; y < this.scaled.getHeight(); ++y) {
                BlockPos renderPos = this.pos.func_177982_a(x, 0, y);
                if (renderPos.func_177951_i((Vector3i)pos) > 30.0) continue;
                Color color = new Color(this.scaled.getRGB(x, y));
                GL11.glColor3f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
                RenderUtil.getInstance().renderBlockOverlay(renderPos.func_177958_n(), renderPos.func_177956_o(), renderPos.func_177952_p(), 0.7f);
            }
        }
    }

    private void renderCorners() {
        BlockPos[] positions;
        for (BlockPos pos : positions = new BlockPos[]{this.pos, this.pos.func_177982_a(0, 0, this.scale * 16 - 1), this.pos.func_177982_a(this.scale * 16 - 1, 0, 0), this.pos.func_177982_a(this.scale * 16 - 1, 0, this.scale * 16 - 1)}) {
            GL11.glColor3f((float)255.0f, (float)255.0f, (float)255.0f);
            RenderUtil.getInstance().renderBlockOverlay(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 2.0);
        }
    }

    public void setImage(BufferedImage img) {
        this.loaded = img;
        this.scaleImage(this.scale);
    }

    public void scaleImage(int scale) {
        this.scale = scale;
        if (this.loaded != null) {
            this.scaled = ImageUtil.getInstance().resize(this.loaded, 16 * this.scale, 16 * this.scale);
        }
    }

    public EnumRenderSettings switchRendering(boolean direction) {
        this.rendering = direction ? JavaUtil.getInstance().getEnumNext(this.rendering) : JavaUtil.getInstance().getEnumPre(this.rendering);
        return this.rendering;
    }

    public Map<Color, BlockSelection> getColorPalete() {
        return this.blockPalete;
    }

    public void setPosition(BlockPos pos) {
        this.pos = pos;
    }

    public int getScale() {
        return this.scale;
    }

    public EnumRenderSettings getRendering() {
        return this.rendering;
    }

    public GuiGroup<GuiQuickAccess> getIngameGui() {
        return this.guis;
    }

    public List<String> getLoadCommands() {
        return this.loadCommands;
    }
}

