/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.module.defined.tools.asedit;

import de.whiletrue.toolsmod.mod.Toolsmod;
import de.whiletrue.toolsmod.module.defined.tools.asedit.EditableArmorStand;
import de.whiletrue.toolsmod.module.defined.tools.asedit.EnumMoveType;
import de.whiletrue.toolsmod.util.classes.ItemUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.play.client.CUseEntityPacket;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class AsEditManager {
    private Minecraft game = Minecraft.func_71410_x();
    private List<EditableArmorStand> stands = new ArrayList<EditableArmorStand>();
    private int selectedStand = -1;
    private EnumMoveType moveMode = EnumMoveType.POSITION;
    private float moveSpeed = 0.1f;
    private int moveAxis = 0;

    public boolean handleMouseScroll(float direction) {
        if (this.moveMode == null) {
            return false;
        }
        float value = this.moveSpeed * direction;
        if (this.selectedStand == -1) {
            this.scrollMultiple(value);
        } else {
            this.scrollSingle(value);
        }
        return true;
    }

    private void scrollMultiple(float value) {
        if (EnumMoveType.POSITION.equals((Object)this.moveMode)) {
            for (EditableArmorStand as : this.stands) {
                if (!as.isSelected()) continue;
                as.updatePosition(this.moveAxis, value / 10.0f);
            }
            return;
        }
        EditableArmorStand middle = this.stands.stream().filter(i -> i.isSelected()).findFirst().get();
        float angle = value / 10.0f;
        for (EditableArmorStand as : this.stands) {
            if (!as.isSelected()) continue;
            as.moveInRelationToStand(middle, angle);
        }
    }

    private void scrollSingle(float value) {
        EditableArmorStand as = this.stands.get(this.selectedStand);
        switch (this.moveMode) {
            case ROTATION: {
                as.updateGeneralRotation(value);
                break;
            }
            case POSITION: {
                as.updatePosition(this.moveAxis, value / 10.0f);
                break;
            }
            default: {
                as.updateBodyRotation(this.moveMode, this.moveAxis, value);
            }
        }
    }

    public boolean handleUseStand(CUseEntityPacket packet) {
        EquipmentSlotType slot;
        Entity ent = packet.func_149564_a((World)this.game.field_71441_e);
        CUseEntityPacket.Action act = packet.func_149565_c();
        if (!(ent instanceof EditableArmorStand)) {
            return false;
        }
        EditableArmorStand stand = (EditableArmorStand)ent;
        if (stand.areSlotsDisabled()) {
            return true;
        }
        if (act.equals((Object)CUseEntityPacket.Action.ATTACK)) {
            stand.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_190931_a));
            return true;
        }
        ItemStack held = this.game.field_71439_g.func_184586_b(Hand.MAIN_HAND).func_77946_l();
        double y = packet.func_179712_b().func_82617_b();
        EquipmentSlotType equipmentSlotType = y > 1.5 ? EquipmentSlotType.HEAD : (y > 0.7 ? EquipmentSlotType.CHEST : (slot = y > 0.5 ? EquipmentSlotType.LEGS : EquipmentSlotType.FEET));
        if (held.func_77973_b().equals(Items.field_190931_a)) {
            stand.func_184201_a(slot, new ItemStack((IItemProvider)Items.field_190931_a));
            return true;
        }
        if (held.func_77973_b() instanceof ArmorItem) {
            ArmorItem ai = (ArmorItem)held.func_77973_b();
            stand.func_184201_a(ai.func_185083_B_(), held);
            return true;
        }
        stand.func_184201_a(EquipmentSlotType.MAINHAND, held);
        return true;
    }

    public void handleSelect(int id) {
        this.setSelected(Math.min(id, this.stands.size() - 1));
        if (this.stands.isEmpty()) {
            this.addDefaultStand();
        } else if (id == -1) {
            if (this.moveMode != null && !this.moveMode.canHandleMultiple()) {
                this.setMode(this.moveMode);
            }
        } else {
            for (int i = 0; i < this.stands.size(); ++i) {
                this.stands.get(i).setSelected(i == this.selectedStand);
            }
        }
    }

    public void deleteAllStandsNoCheck() {
        this.stands.forEach(i -> this.game.field_71441_e.func_217413_d(i.func_145782_y()));
        this.stands.clear();
    }

    public void deleteAllStands() {
        this.deleteAllStandsNoCheck();
        this.addDefaultStand();
    }

    public void doTeleportToPlayer() {
        EditableArmorStand[] selected = (EditableArmorStand[])this.stands.stream().filter(i -> i.isSelected()).toArray(EditableArmorStand[]::new);
        Vector3d middle = selected[0].func_213303_ch();
        Vector3d pos = this.game.field_71439_g.func_213303_ch();
        for (EditableArmorStand s : selected) {
            Vector3d sdiff = s.func_213303_ch().func_178788_d(middle);
            Vector3d diff = pos.func_178787_e(sdiff);
            s.func_70107_b(diff.func_82615_a(), diff.func_82617_b(), diff.func_82616_c());
        }
    }

    public void doMoveList(int index, boolean up) {
        int swapIndex = index + (up ? 1 : -1);
        EditableArmorStand as = this.stands.get(index);
        EditableArmorStand swap = this.stands.get(swapIndex);
        this.stands.set(index, swap);
        this.stands.set(swapIndex, as);
    }

    public int doClone() {
        EditableArmorStand[] cloned = (EditableArmorStand[])this.stands.stream().filter(i -> i.isSelected()).map(i -> {
            i.setSelected(false);
            EditableArmorStand clone = i.doClone();
            clone.setSelected(true);
            return clone;
        }).toArray(EditableArmorStand[]::new);
        this.addAll(cloned);
        int index = this.stands.indexOf((Object)cloned[cloned.length - 1]);
        this.handleSelect(cloned.length <= 1 ? index : -1);
        return index;
    }

    public int doDelete() {
        new ArrayList<EditableArmorStand>(this.stands).forEach(i -> {
            if (!i.isSelected()) {
                return;
            }
            this.game.field_71441_e.func_217413_d(i.func_145782_y());
            this.stands.remove(i);
        });
        for (int i2 = 0; i2 < this.stands.size(); ++i2) {
            if (!this.stands.get(i2).isSelected()) continue;
            this.handleSelect(i2);
            return i2;
        }
        int index = this.selectedStand == -1 ? this.stands.size() - 1 : this.selectedStand;
        this.handleSelect(index);
        return index;
    }

    public int doCreateNew() {
        this.stands.forEach(i -> i.setSelected(false));
        this.addNewStand(this.game.field_71439_g.func_233580_cy_(), null);
        return this.setSelected(this.stands.size() - 1);
    }

    public void doItemToSelected(ItemStack item, EquipmentSlotType slot) {
        EditableArmorStand as = this.stands.get(this.selectedStand);
        as.func_184201_a(slot, item.func_77946_l());
    }

    public void addAll(EditableArmorStand ... stands) {
        for (int i = 0; i < stands.length; ++i) {
            EditableArmorStand s = stands[i];
            this.stands.add(s);
            this.game.field_71441_e.func_217411_a(s.func_145782_y(), (Entity)s);
        }
        this.setSelected(Math.min(this.stands.size() - 1, this.selectedStand));
    }

    private void addDefaultStand() {
        if (!this.stands.isEmpty()) {
            return;
        }
        EditableArmorStand stand = this.addNewStand(this.game.field_71439_g.func_233580_cy_(), null);
        stand.setSelected(true);
        this.setSelected(0);
    }

    public EditableArmorStand addNewStand(BlockPos position, @Nullable CompoundNBT tag) {
        EditableArmorStand stand = new EditableArmorStand(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        if (tag != null) {
            stand.func_70020_e(tag);
        }
        this.stands.add(stand);
        this.game.field_71441_e.func_217411_a(stand.func_145782_y(), (Entity)stand);
        return stand;
    }

    public Vector3d getGlobalRotations() {
        if (EnumMoveType.POSITION.equals((Object)this.moveMode)) {
            return this.getSelectedStand().func_213303_ch();
        }
        Rotations rot = this.moveMode.getRotation(this.getSelectedStand());
        return new Vector3d((double)rot.func_179415_b(), (double)rot.func_179416_c(), (double)rot.func_179413_d());
    }

    public void setGlobalRotation(int axis, float rotation) {
        if (this.moveMode.equals((Object)EnumMoveType.POSITION)) {
            this.getSelectedStand().setPosition(axis, rotation);
            return;
        }
        this.getSelectedStand().setBodyRotation(this.moveMode, axis, rotation);
    }

    public List<ItemStack> getConvertedStands() {
        AtomicInteger counter = new AtomicInteger(1);
        return this.stands.stream().map(i -> {
            CompoundNBT nbt = ItemUtil.getInstance().getTagFromArmorstand((ArmorStandEntity)i);
            CompoundNBT entitytag = new CompoundNBT();
            entitytag.func_218657_a("EntityTag", (INBT)nbt);
            ItemStack stack = new ItemStack((IItemProvider)Items.field_179565_cj);
            stack.func_77982_d(entitytag);
            stack.func_200302_a((ITextComponent)new StringTextComponent(String.format("\u00a78[\u00a7%cASEdit\u00a78] \u00a7%c%d/%d", Character.valueOf('b'), Character.valueOf('6'), counter.getAndIncrement(), this.stands.size())));
            return stack;
        }).collect(Collectors.toList());
    }

    private int setSelected(int id) {
        this.selectedStand = id;
        Toolsmod.getInstance().getModuleManager().updateInfoDisplay();
        return id;
    }

    public EnumMoveType getMode() {
        return this.moveMode;
    }

    public void setMode(EnumMoveType mode) {
        this.moveMode = mode;
        Toolsmod.getInstance().getModuleManager().updateInfoDisplay();
    }

    public float getSpeed() {
        return this.moveSpeed;
    }

    public void setSpeed(float speed) {
        this.moveSpeed = speed;
        Toolsmod.getInstance().getModuleManager().updateInfoDisplay();
    }

    public int getAxis() {
        return this.moveAxis;
    }

    public void setAxis(int axis) {
        this.moveAxis = axis;
        Toolsmod.getInstance().getModuleManager().updateInfoDisplay();
    }

    public List<EditableArmorStand> getStands() {
        return this.stands;
    }

    @Nullable
    public EditableArmorStand getSelectedStand() {
        return this.selectedStand == -1 || this.stands.size() <= 0 ? null : this.stands.get(this.selectedStand);
    }
}

