/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.module.defined.tools.asedit.gui.defined;

import de.whiletrue.toolsmod.gui.widgets.TmAnimatedText;
import de.whiletrue.toolsmod.gui.widgets.TmBackgroundWidget;
import de.whiletrue.toolsmod.gui.widgets.TmTextWidget;
import de.whiletrue.toolsmod.gui.widgets.TmTextfield;
import de.whiletrue.toolsmod.gui.widgets.TmUpdateButton;
import de.whiletrue.toolsmod.gui.widgets.rounding.GuiNode;
import de.whiletrue.toolsmod.module.defined.tools.asedit.EditableArmorStand;
import de.whiletrue.toolsmod.module.defined.tools.asedit.gui.GuiAsEdit;
import de.whiletrue.toolsmod.util.ColorConverter;
import de.whiletrue.toolsmod.util.TextAlign;
import de.whiletrue.toolsmod.util.classes.ImageUtil;
import de.whiletrue.toolsmod.util.classes.JavaUtil;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GuiAsEditImage
extends GuiAsEdit {
    private static final int MAX_SIZE = 100;
    private static final int MIN_SIZE = 1;
    private TmTextWidget imageRenderer;
    private String text;
    private BufferedImage loadedImage;
    private int sizeX = 80;
    private int sizeY = 80;
    private char[] colorChars = new char[]{'4', 'c', '6', 'e', '2', 'a', 'b', '3', '1', '9', 'd', '5', 'f', '7', '8', '0'};
    private ColorConverter converter = new ColorConverter(0xAA0000, 0xFF5555, 0xFFAA00, 0xFFFF55, 43520, 0x55FF55, 0x55FFFF, 43690, 170, 0x5555FF, 0xFF55FF, 0xAA00AA, 0xFFFFFF, 0xAAAAAA, 0x555555, 0);
    private TmAnimatedText info;

    public GuiAsEditImage() {
        super("image.name");
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        GuiNode imageNode = this.getImageFieldNode();
        GuiNode barNode = this.getLoadNode();
        GuiNode settingsNode = this.getSettingsNode();
        int biggerY = Math.max(imageNode.getHeight(), settingsNode.getHeight());
        int spaceX = (this.overlayWidth - imageNode.getWidth() - settingsNode.getWidth()) / 3;
        int spaceY = (this.field_230709_l_ - biggerY - barNode.getHeight()) / 3;
        barNode.init(this.overlayX + this.overlayWidth / 2 - barNode.getWidth() / 2, spaceY);
        imageNode.init(this.overlayX + spaceX * 1, spaceY * 2 + barNode.getHeight() + biggerY / 2 - imageNode.getHeight() / 2);
        settingsNode.init(this.overlayX + spaceX * 2 + imageNode.getWidth(), spaceY * 2 + barNode.getHeight() + biggerY / 2 - settingsNode.getHeight() / 2);
        this.info = new TmAnimatedText(this.overlayX + this.overlayWidth / 2, (int)((float)this.field_230709_l_ * 0.05f)).setTransition(500L, 5000L, 500L);
        this.addWidget(this.info);
        this.info.setScale(2.0).setSpecialRender(true);
    }

    private GuiNode getImageFieldNode() {
        int size = (int)((float)Math.min(this.overlayWidth, this.field_230709_l_) * 0.8f);
        return new GuiNode(size, size, (x, y) -> {
            this.addWidget(new TmBackgroundWidget(x, y, size, size, -1610612736).setOutline(-16777216, 1));
            this.imageRenderer = new TmTextWidget(x + size / 2, y + size / 2, "", -1).setAlignX(TextAlign.MIDDLE).setAlignY(TextAlign.MIDDLE);
            this.addWidget(this.imageRenderer);
            this.imageRenderer.setScale(0.35f);
        });
    }

    private GuiNode getLoadNode() {
        int w = (int)((float)this.overlayWidth * 0.8f);
        int h = 30;
        return new GuiNode(w, 30.0f, (x, y) -> {
            this.addWidget(new TmBackgroundWidget(x, y, w, 30, -1610612736).setOutline(-16777216, 1));
            TmTextfield tf = new TmTextfield(x + 5, y + 15 - 7, w - 90, 15, "", null);
            tf.setMaxStringLength(Integer.MAX_VALUE);
            this.addWidget(tf);
            this.addWidget(new TmUpdateButton(x + w - 80, y + 15 - 10, 70, 20, btn -> {
                if (btn != null) {
                    this.loadImage(tf.getText());
                }
                return TextUtil.getInstance().getByKey("modules.asedit.gui.image.button.preview");
            }));
        });
    }

    private GuiNode getSettingsNode() {
        int size = (int)((float)Math.min(this.overlayWidth, this.field_230709_l_) * 0.8f);
        int w = (int)Math.min((float)(this.overlayWidth - size) * 0.8f, 120.0f);
        int h = (int)((float)this.field_230709_l_ * 0.5f);
        int imgSizeW = (int)((float)w * 0.6f);
        Predicate<String> validator = str -> str.isEmpty() || JavaUtil.getInstance().isInt((String)str);
        BiConsumer<Integer, Boolean> handler = (val, isX) -> {
            if (isX.booleanValue()) {
                this.sizeX = val;
            } else {
                this.sizeY = val;
            }
            this.generateText();
        };
        return new GuiNode(w, h, (x, y) -> {
            this.addWidget(new TmBackgroundWidget(x, y, w, h, -1610612736).setOutline(-16777216, 1));
            this.addWidget(new TmTextWidget(x + w / 2 - imgSizeW / 2, y + 31, "X:", -1));
            TmTextfield fX = new TmTextfield(x + w / 2 - (imgSizeW - 10) / 2 + 5, y + 30, imgSizeW - 10, 10, String.valueOf(this.sizeX), i -> handler.accept(i.isEmpty() ? 0 : Integer.valueOf(i), true));
            fX.setValidator(validator);
            this.addWidget(fX);
            this.addWidget(new TmTextWidget(x + w / 2 - imgSizeW / 2, y + 61, "Y:", -1));
            TmTextfield fY = new TmTextfield(x + w / 2 - (imgSizeW - 10) / 2 + 5, y + 60, imgSizeW - 10, 10, String.valueOf(this.sizeY), i -> handler.accept(i.isEmpty() ? 0 : Integer.valueOf(i), false));
            fY.setValidator(validator);
            this.addWidget(fY);
            this.addWidget(new TmUpdateButton(x + w / 2 - 40, y + h - 40, 80, 20, btn -> {
                if (btn != null) {
                    if (this.text == null) {
                        this.info.showKey(-49859, "modules.asedit.gui.image.error.image", new Object[0]);
                    } else if (this.sizeX > 100 || this.sizeX < 1 || this.sizeY > 100 || this.sizeY < 1) {
                        this.info.showKey(-49859, "modules.asedit.gui.image.error.resize", 1, 100);
                    } else {
                        String[] split = this.text.split("\n");
                        Vector3d pos = this.field_230706_i_.field_71439_g.func_213303_ch();
                        this.manager.getStands().forEach(i -> i.setSelected(false));
                        for (int i2 = split.length - 1; i2 >= 0; --i2) {
                            String name = split[split.length - i2 - 1];
                            if (name.trim().isEmpty()) continue;
                            EditableArmorStand stand = new EditableArmorStand(pos.func_82615_a(), pos.func_82617_b() + (double)i2 * 0.2, pos.func_82616_c());
                            stand.func_82142_c(true);
                            stand.func_184224_h(true);
                            stand.func_189654_d(true);
                            stand.setDisabledSlots(true);
                            stand.setReferenceName("Image-stand");
                            stand.func_200203_b((ITextComponent)new StringTextComponent(name));
                            stand.func_174805_g(true);
                            this.manager.addAll(stand);
                            stand.setSelected(true);
                        }
                        this.manager.handleSelect(-1);
                        this.func_231164_f_();
                    }
                }
                return TextUtil.getInstance().getByKey("modules.asedit.gui.image.button.load");
            }));
        });
    }

    public void loadImage(String file) {
        Optional<BufferedImage> optImg = ImageUtil.getInstance().loadImage(file);
        if (!optImg.isPresent()) {
            this.info.showKey(0xFF3D3D, "modules.asedit.gui.image.error.load", new Object[0]);
            return;
        }
        this.loadedImage = optImg.get();
        this.generateText();
    }

    public void generateText() {
        if (this.loadedImage == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        BufferedImage resized = ImageUtil.getInstance().resize(this.loadedImage, MathHelper.func_76125_a((int)this.sizeX, (int)1, (int)100), MathHelper.func_76125_a((int)this.sizeY, (int)1, (int)100));
        for (int y = 0; y < resized.getHeight(); ++y) {
            for (int x = 0; x < resized.getWidth(); ++x) {
                if (resized.getRGB(x, y) >> 24 == 0) continue;
                char color = this.colorChars[this.converter.nearestIndex(new Color(resized.getRGB(x, y)))];
                sb.append("\u00a7" + color + '\u25a0');
            }
            sb.append("\n");
        }
        int size = (int)((float)Math.min(this.overlayWidth, this.field_230709_l_) * 0.8f);
        this.text = sb.toString();
        this.imageRenderer.setText(this.text.split("\n"));
        this.imageRenderer.setScale((1.0f - (float)Math.max(this.sizeX, this.sizeY) / (float)size) * 0.5f);
    }
}

