/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.module.defined.tools.asedit.gui.defined;

import de.whiletrue.toolsmod.gui.widgets.TmAnimatedText;
import de.whiletrue.toolsmod.gui.widgets.TmBackgroundWidget;
import de.whiletrue.toolsmod.gui.widgets.TmTextWidget;
import de.whiletrue.toolsmod.gui.widgets.TmTextfield;
import de.whiletrue.toolsmod.gui.widgets.TmUpdateButton;
import de.whiletrue.toolsmod.gui.widgets.rounding.GuiNode;
import de.whiletrue.toolsmod.module.defined.tools.asedit.gui.GuiAsEdit;
import de.whiletrue.toolsmod.module.defined.tools.asedit.gui.defined.projects.GuiAsEditProjectsLoad;
import de.whiletrue.toolsmod.module.defined.tools.asedit.projects.AsEditProject;
import de.whiletrue.toolsmod.module.defined.tools.asedit.projects.AsEditProjectManager;
import de.whiletrue.toolsmod.module.defined.tools.asedit.projects.EnumProjectVersion;
import de.whiletrue.toolsmod.util.TextAlign;
import de.whiletrue.toolsmod.util.classes.TextUtil;
import java.io.File;
import java.util.Optional;
import net.minecraft.client.gui.screen.Screen;

public class GuiAsEditProjects
extends GuiAsEdit {
    private TmAnimatedText info;
    private AsEditProjectManager pm;

    public GuiAsEditProjects() {
        super("projects.name");
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.pm = this.module.getPjManager();
        if (this.pm.isLoaded()) {
            this.initLoaded();
        } else {
            this.initUnloaded();
        }
    }

    private void initUnloaded() {
        GuiNode nodeB = this.getInfoBox();
        GuiNode nodeSP = this.getSaveProject();
        GuiNode nodeLP = this.getLoadProject();
        int spaceY = (int)((float)(this.field_230709_l_ - nodeB.getHeight() - Math.max(nodeSP.getHeight(), nodeLP.getHeight())) / 3.0f);
        int spaceX = (int)((float)(this.overlayWidth - nodeLP.getWidth() - nodeSP.getWidth()) / 3.0f);
        nodeB.init(this.overlayX + this.overlayWidth / 2 - nodeB.getWidth() / 2, spaceY);
        nodeSP.init(this.overlayX + spaceX, spaceY * 2 + nodeB.getHeight());
        nodeLP.init(this.overlayX + spaceX * 2 + nodeSP.getWidth(), spaceY * 2 + nodeB.getHeight() + nodeSP.getHeight() / 2 - nodeLP.getHeight() / 2);
        this.info = new TmAnimatedText(this.overlayX + this.overlayWidth / 2, (int)((float)this.field_230709_l_ * 0.05f)).setTransition(2000L, 5000L, 1000L);
        this.addWidget(this.info);
    }

    private GuiNode getLoadProject() {
        int width = (int)((float)this.overlayWidth * 0.3f);
        int height = (int)((float)this.field_230709_l_ * 0.2f);
        return new GuiNode(width, height, (x, y) -> {
            this.addWidget(new TmBackgroundWidget(x, y, width, height, -1610612736).setOutline(-16777216, 1));
            this.addWidget(new TmUpdateButton(x + width / 2 - 40, y + height / 2 - 10, 80, 20, btn -> {
                if (btn != null) {
                    this.field_230706_i_.func_147108_a((Screen)new GuiAsEditProjectsLoad());
                }
                return TextUtil.getInstance().getByKey("modules.asedit.gui.projects.button.manager");
            }));
        });
    }

    private GuiNode getSaveProject() {
        int width = (int)((float)this.overlayWidth * 0.4f);
        int height = 160;
        return new GuiNode(width, 160.0f, (x, y) -> {
            this.addWidget(new TmBackgroundWidget(x, y, width, 160, -1610612736).setOutline(-16777216, 1));
            this.addWidget(new TmTextWidget(x + 10, y + 42, TextUtil.getInstance().trimStringToWidth(TextUtil.getInstance().getByKey("modules.asedit.gui.projects.project.name"), width - 20, "..."), -1).setAlignX(TextAlign.BEFORE));
            TmTextfield nameField = new TmTextfield(x + 10, y + 55, Math.min(width - 20, 150), 15, "", null);
            this.addWidget(nameField);
            this.addWidget(new TmTextWidget(x + 10, y + 42 + 40, TextUtil.getInstance().trimStringToWidth(TextUtil.getInstance().getByKey("modules.asedit.gui.projects.project.author"), width - 20, "..."), -1).setAlignX(TextAlign.BEFORE));
            TmTextfield authorField = new TmTextfield(x + 10, y + 55 + 40, Math.min(width - 20, 120), 15, "", null);
            this.addWidget(authorField);
            this.addWidget(new TmTextWidget(x + 10, y + 42 + 80, TextUtil.getInstance().trimStringToWidth(TextUtil.getInstance().getByKey("modules.asedit.gui.projects.project.version"), width - 20, "..."), -1).setAlignX(TextAlign.BEFORE));
            TmTextfield versionField = new TmTextfield(x + 10, y + 55 + 80, Math.min(width - 20, 50), 15, "", null);
            this.addWidget(versionField);
            this.addWidget(new TmUpdateButton(x + width / 2 - 50, y + 10, 100, 20, btn -> {
                if (btn != null) {
                    if (nameField.getText().trim().isEmpty() || versionField.getText().trim().isEmpty() || authorField.getText().trim().isEmpty()) {
                        this.info.showKey(0xFF6A6A, "modules.asedit.gui.projects.projects.info.given", new Object[0]);
                    } else {
                        File file = new File("toolsmod/assaves/", nameField.getText() + '.' + EnumProjectVersion.NEWEST.getExtension());
                        if (file.exists()) {
                            this.info.showKey(0xFF6A6A, "modules.asedit.gui.projects.projects.info.exists", new Object[0]);
                        } else {
                            AsEditProject project = new AsEditProject(file, nameField.getText().trim(), authorField.getText().trim(), versionField.getText().trim(), EnumProjectVersion.NEWEST);
                            if (this.pm.saveNewProject(project)) {
                                this.field_230706_i_.func_147108_a(null);
                            } else {
                                this.info.showKey(0xFF6A6A, "modules.asedit.gui.projects.projects.info.failed", new Object[0]);
                            }
                        }
                    }
                }
                return TextUtil.getInstance().getByKey("modules.asedit.gui.projects.button.save");
            }));
        });
    }

    private GuiNode getInfoBox() {
        int minWidth = (int)Math.min((float)this.overlayWidth * 0.65f, 250.0f);
        int maxWidth = (int)Math.min((float)this.overlayWidth * 0.8f, 300.0f);
        String infoText = TextUtil.getInstance().getByKey("modules.asedit.gui.projects.infotext");
        String[] splitInfo = TextUtil.getInstance().splitStringOnWidth(infoText, minWidth, maxWidth - 20).split("\n");
        return new GuiNode(maxWidth, splitInfo.length * 10 + 5, (x, y) -> {
            this.addWidget(new TmBackgroundWidget(x, y, maxWidth, splitInfo.length * 10 + 5, -1610612736).setOutline(-16777216, 1));
            this.addWidget(new TmTextWidget(x + maxWidth / 2, y + 5, null, -1).setText(splitInfo));
        });
    }

    private void initLoaded() {
        GuiNode nodeUpBox = this.getUpdateBox();
        GuiNode nodeSettings = this.getSettingsNode();
        int spaceY = (this.field_230709_l_ - nodeUpBox.getHeight() - nodeSettings.getHeight()) / 3;
        nodeUpBox.init(this.overlayX + this.overlayWidth / 2 - nodeUpBox.getWidth() / 2, (int)((float)spaceY * 1.5f));
        nodeSettings.init(this.overlayX + this.overlayWidth / 2 - nodeSettings.getWidth() / 2, (int)((float)spaceY * 2.25f + (float)nodeUpBox.getHeight()));
        this.info = new TmAnimatedText(this.overlayX + this.overlayWidth / 2, (int)((float)this.field_230709_l_ * 0.05f)).setTransition(500L, 5000L, 500L);
        this.addWidget(this.info);
        this.info.setScale(2.0);
    }

    private GuiNode getSettingsNode() {
        int w = 90;
        int h = 60;
        return new GuiNode(90.0f, 60.0f, (x, y) -> {
            this.addWidget(new TmBackgroundWidget(x, y, 90, 60, -1610612736).setOutline(-16777216, 1));
            this.addWidget(new TmUpdateButton(x + 45 - 35, y + 8, 70, 20, btn -> {
                if (btn != null) {
                    this.field_230706_i_.func_147108_a((Screen)new GuiAsEditProjectsLoad());
                }
                return TextUtil.getInstance().getByKey("modules.asedit.gui.projects.button.manager");
            }));
            this.addWidget(new TmUpdateButton(x + 45 - 35, y + 60 - 28, 70, 20, btn -> {
                if (btn != null) {
                    this.pm.setLoaded(null);
                    this.manager.deleteAllStands();
                    this.module.guis.update();
                }
                return TextUtil.getInstance().getByKey("modules.asedit.gui.projects.button.unload");
            }));
        });
    }

    private GuiNode getUpdateBox() {
        int width = (int)Math.min((float)this.overlayWidth * 0.9f, 300.0f);
        int height = 180;
        return new GuiNode(width, 180.0f, (x, y) -> {
            this.addWidget(new TmBackgroundWidget(x, y, width, 180, -1610612736).setOutline(-16777216, 1));
            this.addWidget(new TmTextWidget(x + width / 2, y + 5, TextUtil.getInstance().getByKey("modules.asedit.gui.projects.update.title"), -1));
            this.addWidget(new TmTextWidget(x + width / 2, y + 25, TextUtil.getInstance().trimStringToWidth(TextUtil.getInstance().getByKey("modules.asedit.gui.projects.project.name"), width - 20, "..."), -1));
            TmTextfield nameField = new TmTextfield(x + 20, y + 37, width - 40, 15, "", null);
            nameField.setText(this.pm.getLoaded().getName(-1));
            this.addWidget(nameField);
            this.addWidget(new TmTextWidget(x + width / 2, y + 25 + 38, TextUtil.getInstance().trimStringToWidth(TextUtil.getInstance().getByKey("modules.asedit.gui.projects.project.author"), width - 20, "..."), -1));
            int afW = Math.min(width - 40, 200);
            TmTextfield authorField = new TmTextfield(x + width / 2 - afW / 2, y + 37 + 38, afW, 15, "", null);
            authorField.setText(this.pm.getLoaded().getAuthor(-1));
            this.addWidget(authorField);
            this.addWidget(new TmTextWidget(x + width / 2, y + 25 + 76, TextUtil.getInstance().trimStringToWidth(TextUtil.getInstance().getByKey("modules.asedit.gui.projects.project.version"), width - 20, "..."), -1));
            int vfW = Math.min(width - 40, 150);
            TmTextfield versionField = new TmTextfield(x + width / 2 - vfW / 2, y + 37 + 76, vfW, 15, "", null);
            versionField.setText(this.pm.getLoaded().getVersion(-1));
            this.addWidget(versionField);
            int sbX = x + width / 2 - (this.pm.getLoaded().getVersion().isOutdated() ? 65 : 30);
            TmUpdateButton saveBtn = new TmUpdateButton(sbX, y + 37 + 114, 60, 20, btn -> {
                if (btn != null) {
                    if (nameField.getText().trim().isEmpty() || authorField.getText().trim().isEmpty() || versionField.getText().trim().isEmpty()) {
                        this.info.showKey(0xFF6A6A, "module.asedit.gui.projects.info.given", new Object[0]);
                    } else {
                        this.pm.getLoaded().setName(nameField.getText().trim());
                        this.pm.getLoaded().setAuthor(authorField.getText().trim());
                        this.pm.getLoaded().setProjectVersion(versionField.getText().trim());
                        Optional<String> optError = this.pm.saveProject();
                        if (optError.isPresent()) {
                            this.info.showKey(0xFF6A6A, optError.get(), new Object[0]);
                            this.pm.getLoaded().reload();
                        } else {
                            this.info.showKey(58687, "modules.asedit.gui.projects.save.success", new Object[0]);
                        }
                    }
                }
                return TextUtil.getInstance().getByKey("modules.asedit.gui.projects.button.save");
            });
            this.addWidget(saveBtn);
            if (this.pm.getLoaded().getVersion().isOutdated()) {
                saveBtn.setEnabled(false);
                this.addWidget(new TmUpdateButton(x + width / 2 + 5, y + 37 + 114, 60, 20, btn -> {
                    if (btn != null) {
                        Optional<String> optError = this.pm.getLoaded().convertProject();
                        if (optError.isPresent()) {
                            this.info.showKey(0xFF6A6A, optError.get(), new Object[0]);
                        } else {
                            this.pm.loadProject(this.pm.getLoaded());
                            this.module.guis.update();
                        }
                    }
                    return TextUtil.getInstance().getByKey("modules.asedit.gui.projects.button.convert");
                }));
            }
        });
    }
}

