/*
 * Decompiled with CFR 0.152.
 */
package de.whiletrue.toolsmod.module.defined.tools.asedit.projects;

import de.whiletrue.toolsmod.mod.Toolsmod;
import de.whiletrue.toolsmod.module.defined.tools.asedit.AsEditManager;
import de.whiletrue.toolsmod.module.defined.tools.asedit.EditableArmorStand;
import de.whiletrue.toolsmod.module.defined.tools.asedit.projects.AsEditProject;
import de.whiletrue.toolsmod.module.defined.tools.asedit.projects.EnumProjectVersion;
import java.io.File;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;

public class AsEditProjectManager {
    public static final String SAVE_LOCATION = "assaves";
    private AsEditManager manager;
    private AsEditProject loaded;

    public AsEditProjectManager(AsEditManager managerRef) {
        this.manager = managerRef;
    }

    public boolean saveNewProject(AsEditProject project, EditableArmorStand[] stands) {
        BlockPos relative = Minecraft.func_71410_x().field_71439_g.func_233580_cy_();
        if (EnumProjectVersion.NEWEST.getLoader().saveProject(project, stands, project.getFile(), relative)) {
            this.setLoaded(project);
            return true;
        }
        return false;
    }

    public boolean saveNewProject(AsEditProject project) {
        boolean saved = this.saveNewProject(project, this.manager.getStands().toArray(new EditableArmorStand[this.manager.getStands().size()]));
        if (saved) {
            this.setLoaded(project);
        }
        return saved;
    }

    public Optional<EnumProjectVersion> getLoaderForFile(File file) {
        String[] split = file.getName().split("\\.");
        String extension = split[split.length - 1];
        return EnumProjectVersion.getFromExtension(extension);
    }

    public boolean loadProject(AsEditProject project) {
        EditableArmorStand[] stands = project.loadProject();
        if (stands == null) {
            return false;
        }
        this.setLoaded(project);
        this.manager.deleteAllStandsNoCheck();
        this.manager.addAll(stands);
        for (EditableArmorStand stand : stands) {
            stand.setSelected(true);
        }
        this.manager.handleSelect(stands.length == 1 ? 0 : -1);
        return true;
    }

    public Optional<String> saveProject() {
        return this.loaded.saveProject(this.manager.getStands().toArray(new EditableArmorStand[this.manager.getStands().size()]));
    }

    public boolean isLoaded() {
        return this.loaded != null;
    }

    public void setLoaded(AsEditProject loaded) {
        this.loaded = loaded;
        Toolsmod.getInstance().getModuleManager().updateInfoDisplay();
    }

    public AsEditProject getLoaded() {
        return this.loaded;
    }
}

